/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures;

import com.google.common.collect.Lists;
import com.silverminer.shrines.structures.AbstractStructurePiece;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ColorStructurePiece
extends AbstractStructurePiece {
    protected static final Logger LOG = LogManager.getLogger(ColorStructurePiece.class);
    protected static final ArrayList<Block> WOOLS = Lists.newArrayList((Object[])new Block[]{Blocks.field_196556_aL, Blocks.field_196557_aM, Blocks.field_196558_aN, Blocks.field_196559_aO, Blocks.field_196560_aP, Blocks.field_196561_aQ, Blocks.field_196562_aR, Blocks.field_196563_aS, Blocks.field_196564_aT, Blocks.field_196602_ba, Blocks.field_196565_aU, Blocks.field_196566_aV, Blocks.field_196567_aW, Blocks.field_196568_aX, Blocks.field_196569_aY, Blocks.field_196570_aZ});
    protected static final ArrayList<Block> TERRACOTTAS = Lists.newArrayList((Object[])new Block[]{Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196722_fD, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC});
    protected static final ArrayList<Block> GLAZED_TERRACOTTAS = Lists.newArrayList((Object[])new Block[]{Blocks.field_192427_dB, Blocks.field_192428_dC, Blocks.field_192429_dD, Blocks.field_192430_dE, Blocks.field_192431_dF, Blocks.field_192432_dG, Blocks.field_192433_dH, Blocks.field_192434_dI, Blocks.field_196876_iu, Blocks.field_192442_dQ, Blocks.field_192436_dK, Blocks.field_192437_dL, Blocks.field_192438_dM, Blocks.field_192439_dN, Blocks.field_192440_dO, Blocks.field_192441_dP});
    protected static final ArrayList<Block> CONCRETE = Lists.newArrayList((Object[])new Block[]{Blocks.field_196828_iC, Blocks.field_196830_iD, Blocks.field_196832_iE, Blocks.field_196834_iF, Blocks.field_196836_iG, Blocks.field_196838_iH, Blocks.field_196840_iI, Blocks.field_196842_iJ, Blocks.field_196844_iK, Blocks.field_196858_iR, Blocks.field_196846_iL, Blocks.field_196848_iM, Blocks.field_196850_iN, Blocks.field_196852_iO, Blocks.field_196854_iP, Blocks.field_196856_iQ});
    protected static final ArrayList<Block> CONCRETE_POWDERS = Lists.newArrayList((Object[])new Block[]{Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196884_jh, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg});
    protected static final ArrayList<Block> PLANKS = Lists.newArrayList((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196672_s, Blocks.field_196666_p, Blocks.field_196670_r, Blocks.field_196668_q});
    protected static final ArrayList<Block> ORES = Lists.newArrayList((Object[])new Block[]{Blocks.field_150365_q, Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150450_ax, Blocks.field_150412_bA});
    protected static final ArrayList<Block> STONES = Lists.newArrayList((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_196696_di, Blocks.field_235411_nu_, Blocks.field_150341_Y, Blocks.field_196698_dj, Blocks.field_235412_nv_, Blocks.field_196700_dk});
    protected static final ArrayList<Block> BEES = Lists.newArrayList((Object[])new Block[]{Blocks.field_226906_mb_, Blocks.field_226905_ma_});
    protected final HashMap<Block, Block> COLORS = new HashMap();
    protected boolean defaultValue = true;
    protected final ArrayList<BlockPos> CHANGED_POS = new ArrayList();

    public ColorStructurePiece(IStructurePieceType pieceType, TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn, boolean defaultValue) {
        super(pieceType, templateManager, location, pos, rotation, componentTypeIn);
        this.defaultValue = defaultValue;
        this.addOresOfMoreOre();
    }

    public ColorStructurePiece(IStructurePieceType pieceType, TemplateManager templateManager, CompoundNBT cNBT) {
        super(pieceType, templateManager, cNBT);
        if (cNBT.func_74764_b("DefaultValue")) {
            this.defaultValue = cNBT.func_74767_n("DefaultValue");
        }
        this.addOresOfMoreOre();
    }

    protected void addOresOfMoreOre() {
        Block alexandrit;
        Block silver;
        Block saphire;
        Block ruby = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("moreore", "rubin_ore"));
        if (ruby != null && ruby != Blocks.field_150350_a && !ORES.contains(ruby)) {
            ORES.add(ruby);
        }
        if ((saphire = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("moreore", "saphir_ore"))) != null && ruby != Blocks.field_150350_a && !ORES.contains(saphire)) {
            ORES.add(saphire);
        }
        if ((silver = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("moreore", "silver_ore"))) != null && ruby != Blocks.field_150350_a && !ORES.contains(silver)) {
            ORES.add(silver);
        }
        if ((alexandrit = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("moreore", "alexandrit_ore"))) != null && ruby != Blocks.field_150350_a && !ORES.contains(alexandrit)) {
            ORES.add(alexandrit);
        }
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74757_a("DefaultValue", this.defaultValue);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox mbb, ChunkPos chunkPos, BlockPos blockPos) {
        BlockState newBlock;
        boolean flag = super.func_230383_a_(world, structureManager, chunkGen, rand, mbb, chunkPos, blockPos);
        Biome biome = chunkGen.func_202090_b().func_225526_b_(chunkPos.field_77276_a, 0, chunkPos.field_77275_b);
        if (this.useRandomVarianting()) {
            if (this.overwriteWool()) {
                for (Block block : WOOLS) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, WOOLS.get(rand.nextInt(WOOLS.size())));
                    }
                    newBlock = this.COLORS.get(block).func_176223_P();
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        if (block == Blocks.field_196602_ba) {
                            newBlock = WOOLS.get(rand.nextInt(WOOLS.size())).func_176223_P();
                        }
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                    }
                }
            }
            if (this.overwriteWood()) {
                for (Block block : PLANKS) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, this.getPlankByBiome(biome, block, rand));
                    }
                    newBlock = this.COLORS.get(block);
                    if (this.overwritePlanks()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock.func_176223_P(), world, rand);
                        }
                    }
                    if (this.overwriteSlabs()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getSlab(block))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)this.getSlab((Block)newBlock).func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)((SlabType)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)SlabBlock.field_196505_a))), world, rand);
                        }
                    }
                    if (this.overwriteFences()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getFence(block))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getFence((Block)newBlock).func_176223_P().func_206870_a((Property)FenceBlock.field_196409_a, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)FenceBlock.field_196409_a)))).func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)FenceBlock.field_196411_b)))).func_206870_a((Property)FenceBlock.field_196413_c, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)FenceBlock.field_196413_c)))).func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)FenceBlock.field_196414_y)))).func_206870_a((Property)FenceBlock.field_204514_u, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)FenceBlock.field_204514_u))), world, rand);
                        }
                    }
                    if (this.overwriteLogs()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getLog(block, false))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)this.getLog((Block)newBlock, false).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)((Direction.Axis)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)RotatedPillarBlock.field_176298_M))), world, rand);
                        }
                    }
                    if (this.overwriteStrippedLogs()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getLog(block, true))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)this.getLog((Block)newBlock, true).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)((Direction.Axis)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)RotatedPillarBlock.field_176298_M))), world, rand);
                        }
                    }
                    if (this.overwriteTrapdoors()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getTrapdoor(block))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getTrapdoor((Block)newBlock).func_176223_P().func_206870_a((Property)TrapDoorBlock.field_176285_M, (Comparable)((Half)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)TrapDoorBlock.field_176285_M)))).func_206870_a((Property)TrapDoorBlock.field_176283_b, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)TrapDoorBlock.field_176283_b)))).func_206870_a((Property)TrapDoorBlock.field_196381_c, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)TrapDoorBlock.field_196381_c)))).func_206870_a((Property)TrapDoorBlock.field_204614_t, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)TrapDoorBlock.field_204614_t)))).func_206870_a((Property)TrapDoorBlock.field_185512_D, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)TrapDoorBlock.field_185512_D))), world, rand);
                        }
                    }
                    if (this.overwriteDoors()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getDoor(block))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getDoor((Block)newBlock).func_176223_P().func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)DoorBlock.field_176519_b)))).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)((DoorHingeSide)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)DoorBlock.field_176521_M)))).func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)DoorBlock.field_176520_a)))).func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)((DoubleBlockHalf)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)DoorBlock.field_176523_O)))).func_206870_a((Property)DoorBlock.field_176522_N, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)DoorBlock.field_176522_N))), world, rand);
                        }
                    }
                    if (this.overwriteStairs()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getStairs(block))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)((BlockState)((BlockState)this.getStairs((Block)newBlock).func_176223_P().func_206870_a((Property)StairsBlock.field_204513_t, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)StairsBlock.field_204513_t)))).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)StairsBlock.field_176309_a)))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)((Half)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)StairsBlock.field_176308_b)))).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)((StairsShape)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)StairsBlock.field_176310_M))), world, rand);
                        }
                    }
                    if (this.overwriteSigns()) {
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getSign(block, true))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)this.getSign((Block)newBlock, true).func_176223_P().func_206870_a((Property)AbstractSignBlock.field_204613_a, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)AbstractSignBlock.field_204613_a)))).func_206870_a((Property)WallSignBlock.field_176412_a, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)WallSignBlock.field_176412_a))), world, rand);
                        }
                        for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getSign(block, false))) {
                            this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)this.getSign((Block)newBlock, true).func_176223_P().func_206870_a((Property)AbstractSignBlock.field_204613_a, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)AbstractSignBlock.field_204613_a)))).func_206870_a((Property)StandingSignBlock.field_176413_a, (Comparable)((Integer)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)StandingSignBlock.field_176413_a))), world, rand);
                        }
                    }
                    if (!this.overwriteButtons()) continue;
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getButton(block))) {
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)((BlockState)this.getButton((Block)newBlock).func_176223_P().func_206870_a((Property)AbstractButtonBlock.field_176584_b, (Comparable)((Boolean)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)AbstractButtonBlock.field_176584_b)))).func_206870_a((Property)AbstractButtonBlock.field_196366_M, (Comparable)((AttachFace)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)AbstractButtonBlock.field_196366_M)))).func_206870_a((Property)AbstractButtonBlock.field_185512_D, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)AbstractButtonBlock.field_185512_D))), world, rand);
                    }
                }
            }
            if (this.overwriteTerracotta()) {
                for (Block block : TERRACOTTAS) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, TERRACOTTAS.get(rand.nextInt(TERRACOTTAS.size())));
                    }
                    newBlock = this.COLORS.get(block).func_176223_P();
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        if (block == Blocks.field_196722_fD) {
                            newBlock = TERRACOTTAS.get(rand.nextInt(TERRACOTTAS.size())).func_176223_P();
                        }
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                    }
                }
            }
            if (this.overwriteGlazedTerracotta()) {
                for (Block block : GLAZED_TERRACOTTAS) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, GLAZED_TERRACOTTAS.get(rand.nextInt(GLAZED_TERRACOTTAS.size())));
                    }
                    newBlock = this.COLORS.get(block).func_176223_P();
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        if (block == Blocks.field_192442_dQ) {
                            newBlock = GLAZED_TERRACOTTAS.get(rand.nextInt(GLAZED_TERRACOTTAS.size())).func_176223_P();
                        }
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                    }
                }
            }
            if (this.overwriteConcrete()) {
                for (Block block : CONCRETE) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, CONCRETE.get(rand.nextInt(CONCRETE.size())));
                    }
                    newBlock = this.COLORS.get(block).func_176223_P();
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        if (block == Blocks.field_196858_iR) {
                            newBlock = CONCRETE.get(rand.nextInt(CONCRETE.size())).func_176223_P();
                        }
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                    }
                }
            }
            if (this.overwriteConcretePowder()) {
                for (Block block : CONCRETE_POWDERS) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, CONCRETE_POWDERS.get(rand.nextInt(CONCRETE_POWDERS.size())));
                    }
                    newBlock = this.COLORS.get(block).func_176223_P();
                    for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        if (block == Blocks.field_196884_jh) {
                            newBlock = CONCRETE_POWDERS.get(rand.nextInt(CONCRETE_POWDERS.size())).func_176223_P();
                        }
                        this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                    }
                }
            }
            if (this.overwriteStone()) {
                for (Block block : STONES) {
                    if (this.COLORS.get(block) == null) {
                        this.COLORS.put(block, STONES.get(rand.nextInt(STONES.size())));
                    }
                    BlockState newBlock2 = newBlock = this.COLORS.get(block);
                    for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                        newBlock2 = newBlock;
                        if (rand.nextFloat() < this.getStoneChangeChance()) {
                            newBlock2 = STONES.get(rand.nextInt(STONES.size()));
                        }
                        this.changeBlock(template$blockinfo.field_186242_a, newBlock2.func_176223_P(), world, rand);
                    }
                    if (this.overwriteSlabs()) {
                        for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getSlab(block))) {
                            newBlock2 = newBlock;
                            if (rand.nextFloat() < this.getStoneChangeChance()) {
                                newBlock2 = STONES.get(rand.nextInt(STONES.size()));
                            }
                            this.changeBlock(template$blockinfo.field_186242_a, (BlockState)this.getSlab((Block)newBlock2).func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)((SlabType)template$blockinfo.field_186243_b.func_177229_b((Property)SlabBlock.field_196505_a))), world, rand);
                        }
                    }
                    if (!this.overwriteStairs()) continue;
                    for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, this.getStairs(block))) {
                        newBlock2 = newBlock;
                        if (rand.nextFloat() < this.getStoneChangeChance()) {
                            newBlock2 = STONES.get(rand.nextInt(STONES.size()));
                        }
                        this.changeBlock(template$blockinfo.field_186242_a, (BlockState)((BlockState)((BlockState)((BlockState)this.getStairs((Block)newBlock2).func_176223_P().func_206870_a((Property)StairsBlock.field_204513_t, (Comparable)((Boolean)template$blockinfo.field_186243_b.func_177229_b((Property)StairsBlock.field_204513_t)))).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)((Direction)template$blockinfo.field_186243_b.func_177229_b((Property)StairsBlock.field_176309_a)))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)((Half)template$blockinfo.field_186243_b.func_177229_b((Property)StairsBlock.field_176308_b)))).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)((StairsShape)template$blockinfo.field_186243_b.func_177229_b((Property)StairsBlock.field_176310_M))), world, rand);
                    }
                }
            }
        }
        if (this.overwriteBeehives()) {
            for (Block block : BEES) {
                if (this.COLORS.get(block) == null) {
                    this.COLORS.put(block, BEES.get(rand.nextInt(BEES.size())));
                }
                newBlock = this.COLORS.get(block).func_176223_P();
                for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                    this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, (BlockState)((BlockState)newBlock.func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)((Direction)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)BeehiveBlock.field_226872_b_)))).func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)((Integer)((Template.BlockInfo)template$blockinfo).field_186243_b.func_177229_b((Property)BeehiveBlock.field_226873_c_))), world, rand);
                }
            }
        }
        if (this.overwriteOres()) {
            for (Block block : ORES) {
                if (this.COLORS.get(block) == null) {
                    this.COLORS.put(block, ORES.get(rand.nextInt(ORES.size())));
                }
                newBlock = this.COLORS.get(block).func_176223_P();
                for (Object template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, block)) {
                    this.changeBlock(((Template.BlockInfo)template$blockinfo).field_186242_a, newBlock, world, rand);
                }
            }
        }
        return flag;
    }

    protected Block getPlankByBiome(Biome biome, Block block, Random rand) {
        if (block != this.getDefaultPlank()) {
            return PLANKS.get(rand.nextInt(PLANKS.size() - 1));
        }
        switch (biome.func_201856_r()) {
            case TAIGA: {
                return Blocks.field_196664_o;
            }
            case SAVANNA: {
                return Blocks.field_196670_r;
            }
            case JUNGLE: {
                return Blocks.field_196668_q;
            }
            case SWAMP: {
                return Blocks.field_196662_n;
            }
            case FOREST: {
                if (biome.getRegistryName() == Biomes.field_150583_P.getRegistryName() || biome.getRegistryName() == Biomes.field_150582_Q.getRegistryName() || biome.getRegistryName() == Biomes.field_185448_Z.getRegistryName() || biome.getRegistryName() == Biomes.field_185429_aa.getRegistryName()) {
                    return Blocks.field_196666_p;
                }
                if (biome.getRegistryName() == Biomes.field_150585_R.getRegistryName() || biome.getRegistryName() == Biomes.field_185430_ab.getRegistryName()) {
                    return Blocks.field_196670_r;
                }
                return Blocks.field_196662_n;
            }
        }
        return PLANKS.get(rand.nextInt(PLANKS.size() - 1));
    }

    public Block getDefaultPlank() {
        return Blocks.field_196662_n;
    }

    protected abstract boolean useRandomVarianting();

    protected boolean changeBlock(BlockPos pos, BlockState state, ISeedReader world, Random rand) {
        if (!this.CHANGED_POS.contains(pos) && this.validateBlock(pos, state, world, rand)) {
            this.CHANGED_POS.add(pos);
            world.func_180501_a(pos, state, 3);
            return true;
        }
        return false;
    }

    public boolean validateBlock(BlockPos pos, BlockState newState, ISeedReader world, Random rand) {
        return true;
    }

    protected Block getSlab(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_196622_bq;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_196635_bv;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_196627_bs;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_196630_bt;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_196632_bu;
        }
        if (plank == Blocks.field_150347_e) {
            return Blocks.field_196646_bz;
        }
        if (plank == Blocks.field_196696_di) {
            return Blocks.field_196573_bB;
        }
        if (plank == Blocks.field_235411_nu_) {
            return Blocks.field_235414_nx_;
        }
        if (plank == Blocks.field_150341_Y) {
            return Blocks.field_222450_ln;
        }
        if (plank == Blocks.field_196698_dj) {
            return Blocks.field_222448_ll;
        }
        if (plank == Blocks.field_235412_nv_) {
            return Blocks.field_235414_nx_;
        }
        if (plank == Blocks.field_196700_dk) {
            return Blocks.field_196573_bB;
        }
        return Blocks.field_196624_br;
    }

    protected Block getButton(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_196689_eF;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_196699_eK;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_196693_eH;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_196695_eI;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_196697_eJ;
        }
        return Blocks.field_196691_eG;
    }

    protected Block getFence(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_180407_aO;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_180406_aS;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_180404_aQ;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_180403_aR;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_180405_aT;
        }
        return Blocks.field_180408_aP;
    }

    protected Block getLog(Block plank, boolean stripped) {
        if (plank == Blocks.field_196662_n) {
            if (stripped) {
                return Blocks.field_203204_R;
            }
            return Blocks.field_196617_K;
        }
        if (plank == Blocks.field_196672_s) {
            if (stripped) {
                return Blocks.field_203209_W;
            }
            return Blocks.field_196623_P;
        }
        if (plank == Blocks.field_196666_p) {
            if (stripped) {
                return Blocks.field_203206_T;
            }
            return Blocks.field_196619_M;
        }
        if (plank == Blocks.field_196668_q) {
            if (stripped) {
                return Blocks.field_203207_U;
            }
            return Blocks.field_196620_N;
        }
        if (plank == Blocks.field_196670_r) {
            if (stripped) {
                return Blocks.field_203208_V;
            }
            return Blocks.field_196621_O;
        }
        if (stripped) {
            return Blocks.field_203205_S;
        }
        return Blocks.field_196618_L;
    }

    protected Block getTrapdoor(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_196636_cW;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_196684_db;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_196641_cY;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_196644_cZ;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_196682_da;
        }
        return Blocks.field_196638_cX;
    }

    protected Block getDoor(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_180413_ao;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_180409_at;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_180412_aq;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_180411_ar;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_180410_as;
        }
        return Blocks.field_180414_ap;
    }

    protected Block getStairs(Block plank) {
        if (plank == Blocks.field_196662_n) {
            return Blocks.field_150476_ad;
        }
        if (plank == Blocks.field_196672_s) {
            return Blocks.field_150401_cl;
        }
        if (plank == Blocks.field_196666_p) {
            return Blocks.field_150487_bG;
        }
        if (plank == Blocks.field_196668_q) {
            return Blocks.field_150481_bH;
        }
        if (plank == Blocks.field_196670_r) {
            return Blocks.field_150400_ck;
        }
        if (plank == Blocks.field_150347_e) {
            return Blocks.field_196659_cl;
        }
        if (plank == Blocks.field_196696_di) {
            return Blocks.field_150390_bg;
        }
        if (plank == Blocks.field_235411_nu_) {
            return Blocks.field_235415_ny_;
        }
        if (plank == Blocks.field_150341_Y) {
            return Blocks.field_222411_kZ;
        }
        if (plank == Blocks.field_196698_dj) {
            return Blocks.field_222409_kX;
        }
        if (plank == Blocks.field_235412_nv_) {
            return Blocks.field_235415_ny_;
        }
        if (plank == Blocks.field_196700_dk) {
            return Blocks.field_150390_bg;
        }
        return Blocks.field_150485_bF;
    }

    protected Block getSign(Block plank, boolean wall) {
        if (plank == Blocks.field_196662_n) {
            if (wall) {
                return Blocks.field_222392_ch;
            }
            return Blocks.field_222384_bX;
        }
        if (plank == Blocks.field_196672_s) {
            if (wall) {
                return Blocks.field_222397_cm;
            }
            return Blocks.field_222391_cc;
        }
        if (plank == Blocks.field_196666_p) {
            if (wall) {
                return Blocks.field_222394_cj;
            }
            return Blocks.field_222386_bZ;
        }
        if (plank == Blocks.field_196668_q) {
            if (wall) {
                return Blocks.field_222396_cl;
            }
            return Blocks.field_222390_cb;
        }
        if (plank == Blocks.field_196670_r) {
            if (wall) {
                return Blocks.field_222395_ck;
            }
            return Blocks.field_222389_ca;
        }
        if (wall) {
            return Blocks.field_222393_ci;
        }
        return Blocks.field_222385_bY;
    }

    @Override
    protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(function));
        if (block != Blocks.field_150350_a) {
            worldIn.func_180501_a(pos, block.func_176223_P(), 2);
            this.CHANGED_POS.add(pos);
        }
    }

    public boolean overwriteOres() {
        return false;
    }

    public boolean overwriteWool() {
        return this.defaultValue;
    }

    public boolean overwriteWood() {
        return this.defaultValue;
    }

    public boolean overwritePlanks() {
        return this.defaultValue;
    }

    public boolean overwriteSlabs() {
        return this.defaultValue;
    }

    public boolean overwriteFences() {
        return this.defaultValue;
    }

    public boolean overwriteLogs() {
        return this.defaultValue;
    }

    public boolean overwriteStrippedLogs() {
        return this.defaultValue;
    }

    public boolean overwriteSigns() {
        return this.defaultValue;
    }

    public boolean overwriteStairs() {
        return this.defaultValue;
    }

    public boolean overwriteDoors() {
        return this.defaultValue;
    }

    public boolean overwriteTrapdoors() {
        return this.defaultValue;
    }

    public boolean overwriteTerracotta() {
        return this.defaultValue;
    }

    public boolean overwriteGlazedTerracotta() {
        return this.defaultValue;
    }

    public boolean overwriteConcretePowder() {
        return this.defaultValue;
    }

    public boolean overwriteConcrete() {
        return this.defaultValue;
    }

    public boolean overwriteStone() {
        return this.defaultValue;
    }

    public float getStoneChangeChance() {
        return 0.05f;
    }

    public boolean overwriteButtons() {
        return this.defaultValue;
    }

    public boolean overwriteBeehives() {
        return this.defaultValue;
    }
}

