/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.custom;

import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import com.silverminer.shrines.structures.custom.helper.PieceData;
import com.silverminer.shrines.utils.ModTemplateManager;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPiece {
    protected static final Logger LOGGER = LogManager.getLogger(CustomPiece.class);

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random, boolean useRandomVarianting, List<PieceData> parts, String name, boolean ignore_air) {
        for (PieceData pd : parts) {
            String piece = pd.path;
            pieces.add((StructurePiece)new Piece(templateManager, new ResourceLocation("shrines", name + "/" + piece), pos.func_177971_a((Vector3i)pd.offset.func_190942_a(rotation)), rotation, 0, random, useRandomVarianting, ignore_air));
        }
    }

    public static class Piece
    extends ColorStructurePiece {
        public boolean useRandomVarianting = false;
        public int heightOffset = 0;
        public boolean ignore_air = true;

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn, Random rand, boolean useRandomVarianting, boolean ignore_air) {
            super(StructurePieceTypes.CUSTOM, templateManager, location, pos, rotation, componentTypeIn, true);
            this.useRandomVarianting = useRandomVarianting;
            this.heightOffset = pos.func_177956_o();
            this.ignore_air = ignore_air;
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.CUSTOM, templateManager, cNBT);
            this.useRandomVarianting = cNBT.func_74767_n("varianting");
            this.heightOffset = cNBT.func_74762_e("height");
            this.ignore_air = cNBT.func_74767_n("ignore_air");
        }

        @Override
        public void setup(TemplateManager templateManager) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            try {
                Template template = new ModTemplateManager(server.func_71209_f("shrines-saves").getCanonicalFile().toPath(), server.func_195563_aC()).getOrCreate(this.location);
                PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a(this.getProcessor());
                this.func_186173_a(template, this.field_186178_c, placementsettings);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("varianting", this.useRandomVarianting);
            tagCompound.func_74768_a("height", this.heightOffset);
            tagCompound.func_74757_a("ignore_air", this.ignore_air);
        }

        @Override
        protected int getHeight(ISeedReader world, BlockPos blockpos1) {
            return super.getHeight(world, blockpos1) + this.heightOffset - 1;
        }

        @Override
        public StructureProcessor getProcessor() {
            if (this.ignore_air) {
                return BlockIgnoreStructureProcessor.field_215206_c;
            }
            return BlockIgnoreStructureProcessor.field_215204_a;
        }

        @Override
        protected boolean useRandomVarianting() {
            return this.useRandomVarianting;
        }
    }
}

