/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.custom;

import com.mojang.serialization.Codec;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.config.StructureConfig;
import com.silverminer.shrines.structures.AbstractStructure;
import com.silverminer.shrines.structures.AbstractStructureStart;
import com.silverminer.shrines.structures.custom.CustomPiece;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomStructure
extends AbstractStructure<NoFeatureConfig> {
    protected static final Logger LOG = LogManager.getLogger(CustomStructure.class);
    private CustomStructureData csd;

    public CustomStructure(Codec<NoFeatureConfig> codec, String name, CustomStructureData csd) {
        super(codec, 3, name);
        this.csd = csd;
    }

    @Override
    public boolean isEndStructure() {
        return this.csd.categories.getValue().contains(Biome.Category.THEEND);
    }

    @Override
    public boolean isNetherStructure() {
        return this.csd.categories.getValue().contains(Biome.Category.NETHER);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @Override
    public StructureConfig.StructureGenConfig getConfig() {
        return Config.STRUCTURES.CUSTOM;
    }

    @Override
    public int getDistance() {
        return this.csd.distance.getValue();
    }

    @Override
    public int getSeparation() {
        return this.csd.seperation.getValue();
    }

    @Override
    public int getSeedModifier() {
        return this.csd.seed.getValue();
    }

    @Override
    public double getSpawnChance() {
        return this.csd.spawn_chance.getValue();
    }

    @Override
    public boolean needsGround() {
        return this.csd.needs_ground.getValue();
    }

    public boolean validateSpawn(ResourceLocation name, Biome.Category category) {
        if (!this.csd.generate.getValue().booleanValue()) {
            return false;
        }
        boolean flag = this.csd.categories.getValue().contains(category);
        if (!this.csd.blacklist.getValue().isEmpty() && flag) {
            flag = !this.csd.blacklist.getValue().contains(name.toString());
        }
        return flag;
    }

    public static class Start
    extends AbstractStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingbox, int p_i225806_5_, long seed) {
            super(structure, chunkX, chunkZ, boundingbox, p_i225806_5_, seed);
        }

        public void generatePieces(DynamicRegistries registries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            BlockPos blockpos = new BlockPos(i, 1, j);
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            if (!(this.func_214627_k() instanceof CustomStructure)) {
                return;
            }
            CustomStructure cS = (CustomStructure)this.func_214627_k();
            CustomPiece.generate(templateManager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, ((CustomStructure)cS).csd.use_random_varianting.getValue(), ((CustomStructure)cS).csd.pieces.getValue(), cS.name, ((CustomStructure)cS).csd.ignore_air.getValue());
            this.func_202500_a();
        }
    }
}

