/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.custom.helper;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import com.silverminer.shrines.utils.OptionParsingResult;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigOption<T> {
    protected static final Logger LOGGER = LogManager.getLogger(ConfigOption.class);
    private final String name;
    private T value;
    private Function<String, T> fromString;
    private ArgumentType<?> argument;
    private BiFunction<CommandContext<CommandSource>, String, ?> argument_to_string;

    public <U> ConfigOption(String name, T value, Function<String, T> fromString, ArgumentType<U> argument, BiFunction<CommandContext<CommandSource>, String, U> argument_to_string) {
        this.name = name;
        this.value = value;
        this.fromString = fromString;
        this.argument = argument;
        this.argument_to_string = argument_to_string;
    }

    public OptionParsingResult fromString(String s, CustomStructureData csd) {
        T v = s.startsWith(this.getName() + ":") ? this.fromString.apply(s.replace(this.getName() + ":", "")) : this.fromString.apply(s);
        if (v == null) {
            return new OptionParsingResult(false, (ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.wrong_value", new Object[]{s, this.getName()}));
        }
        if (csd.distance.equals(this)) {
            if ((Integer)v <= csd.seperation.getValue()) {
                return new OptionParsingResult(false, (ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.dist_larger_sep", new Object[]{v, csd.seperation.getValue()}));
            }
        } else if (csd.seperation.equals(this)) {
            if ((Integer)v >= csd.distance.getValue()) {
                return new OptionParsingResult(false, (ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.sep_smaller_dist", new Object[]{v, csd.distance.getValue()}));
            }
        } else if (csd.spawn_chance.equals(this)) {
            Double d = (Double)v;
            if (d < 0.0 || d > 1.0) {
                return new OptionParsingResult(false, (ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.chance_out_of_range", new Object[]{v}));
            }
        } else if (csd.seed.equals(this)) {
            Integer i = (Integer)v;
            if (i < 0) {
                return this.fromString(String.valueOf(i * -1), csd).setMessage((ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.seed_set_positive"));
            }
            if (i == 0) {
                return this.fromString(String.valueOf(new Random().nextInt(Integer.MAX_VALUE)), csd).setMessage((ITextComponent)new TranslationTextComponent("commands.shrines.configure.failed.seed_set_random"));
            }
        }
        this.setValue(v);
        return new OptionParsingResult(true, null);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigOption) {
            return ((ConfigOption)o).getName() == this.getName();
        }
        return false;
    }

    public void setValue(T v) {
        this.value = v;
    }

    public String toString() {
        return this.name + ":" + String.valueOf(this.value);
    }

    public T getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public ArgumentType<?> getArgument() {
        return this.argument;
    }

    public BiFunction<CommandContext<CommandSource>, String, ?> getCommandValueFunction() {
        return this.argument_to_string;
    }

    public Object getCommandValue(CommandContext<CommandSource> ctx, String s) {
        try {
            Object o = this.getCommandValueFunction().apply(ctx, "value");
            return o;
        }
        catch (Throwable t) {
            LOGGER.error((Object)t);
            return null;
        }
    }
}

