/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.custom.helper;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.silverminer.shrines.structures.custom.helper.ConfigOption;
import com.silverminer.shrines.structures.custom.helper.PieceData;
import com.silverminer.shrines.utils.OptionParsingResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomStructureData {
    protected static final Logger LOGGER = LogManager.getLogger(CustomStructureData.class);
    public static final List<String> OPTIONS = Lists.newArrayList();
    public final String name;
    public final List<ConfigOption<?>> CONFIGS = Lists.newArrayList();
    public ConfigOption<Boolean> generate = this.add(new ConfigOption<Boolean>("generate", true, Boolean::valueOf, BoolArgumentType.bool(), BoolArgumentType::getBool));
    public ConfigOption<Double> spawn_chance = this.add(new ConfigOption<Double>("spawn_chance", 0.6, Double::valueOf, DoubleArgumentType.doubleArg((double)0.0, (double)1.0), DoubleArgumentType::getDouble));
    public ConfigOption<Boolean> needs_ground = this.add(new ConfigOption<Boolean>("needs_ground", true, Boolean::valueOf, BoolArgumentType.bool(), BoolArgumentType::getBool));
    public ConfigOption<Boolean> use_random_varianting = this.add(new ConfigOption<Boolean>("use_random_varianting", true, Boolean::valueOf, BoolArgumentType.bool(), BoolArgumentType::getBool));
    public ConfigOption<Integer> distance = this.add(new ConfigOption<Integer>("distance", 50, Integer::valueOf, IntegerArgumentType.integer(), IntegerArgumentType::getInteger));
    public ConfigOption<Integer> seed;
    public ConfigOption<Integer> seperation = this.add(new ConfigOption<Integer>("seperation", 8, Integer::valueOf, IntegerArgumentType.integer(), IntegerArgumentType::getInteger));
    public ConfigOption<List<Biome.Category>> categories = this.add(new ConfigOption<List>("categories", Lists.newArrayList((Object[])new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.TAIGA, Biome.Category.FOREST}), CustomStructureData::readCategories, StringArgumentType.greedyString(), StringArgumentType::getString));
    public ConfigOption<List<String>> blacklist = this.add(new ConfigOption<List>("blacklist", Lists.newArrayList(), CustomStructureData::readBlackList, StringArgumentType.greedyString(), StringArgumentType::getString));
    public ConfigOption<List<PieceData>> pieces = this.add(new ConfigOption<List>("pieces", Lists.newArrayList((Object[])new PieceData[]{new PieceData("resource", BlockPos.field_177992_a)}), CustomStructureData::readPieces, StringArgumentType.greedyString(), StringArgumentType::getString));
    public ConfigOption<Boolean> ignore_air = this.add(new ConfigOption<Boolean>("ignore_air", true, Boolean::valueOf, BoolArgumentType.bool(), BoolArgumentType::getBool));

    public CustomStructureData(String name, Random rand) {
        this(name, rand.nextInt(Integer.MAX_VALUE));
    }

    public CustomStructureData(String name, int seed) {
        this.name = name;
        this.seed = this.add(new ConfigOption<Integer>("seed", seed, Integer::valueOf, IntegerArgumentType.integer((int)0), IntegerArgumentType::getInteger));
    }

    public <T> ConfigOption<T> add(ConfigOption<T> option) {
        if (!OPTIONS.contains(option.getName())) {
            OPTIONS.add(option.getName());
        }
        if (!this.CONFIGS.contains(option)) {
            this.CONFIGS.add(option);
        }
        return option;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String config = "";
        for (ConfigOption<?> co : this.CONFIGS) {
            config = config + co.toString() + ";";
        }
        return config;
    }

    public String toStringReadAble() {
        return this.toString().replaceAll(";", ";\n");
    }

    public void fromString(String config) {
        String sub;
        int idx2;
        int idx;
        config = config.replaceAll(" ", "").replaceAll("\n", "");
        while ((idx = config.indexOf(";")) != -1 && (idx2 = (sub = config.substring(0, idx)).indexOf(":")) != -1) {
            this.fromString(sub.substring(0, idx2), sub.substring(idx2 + 1));
            if (config.length() <= idx + 1) break;
            config = config.substring(idx + 1);
        }
    }

    public OptionParsingResult fromString(String option, String value) {
        for (ConfigOption<?> co : this.CONFIGS) {
            if (!co.getName().equals(option)) continue;
            OptionParsingResult res = co.fromString(value, this);
            return res;
        }
        return new OptionParsingResult(false, null);
    }

    public static List<Biome.Category> readCategories(String s) {
        if (s.startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
        }
        try {
            ArrayList cats = Lists.newArrayList();
            while (s.contains(",")) {
                int idx = s.lastIndexOf(",");
                cats.add(s.substring(idx + 1));
                s = s.substring(0, idx);
            }
            cats.add(s);
            ArrayList categories = Lists.newArrayList();
            for (String cat : cats) {
                if (cat.equals("DEFAULT")) {
                    return Lists.newArrayList((Object[])new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.TAIGA, Biome.Category.FOREST});
                }
                if (cat.equals("ALL")) {
                    return Lists.newArrayList((Object[])Biome.Category.values());
                }
                Biome.Category c = Biome.Category.valueOf((String)cat);
                if (c == null) continue;
                categories.add(c);
            }
            return categories;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to parse [{}] to Categories", (Object)s);
            return null;
        }
    }

    public static List<String> readBlackList(String s) {
        if (s.startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
            ArrayList list = Lists.newArrayList();
            while (s.contains(",")) {
                int idx = s.lastIndexOf(",");
                list.add(s.substring(idx + 1));
                s = s.substring(0, idx);
            }
            list.add(s);
            return list;
        }
        return Lists.newArrayList();
    }

    public static List<PieceData> readPieces(String s) {
        if (s.startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
            ArrayList cats = Lists.newArrayList();
            while (s.contains("+")) {
                int idx = s.lastIndexOf("+");
                cats.add(s.substring(idx + 1));
                s = s.substring(0, idx);
            }
            cats.add(s);
            ArrayList categories = Lists.newArrayList();
            for (String cat : cats) {
                PieceData c = PieceData.fromString(cat);
                if (c == null) continue;
                categories.add(c);
            }
            return categories;
        }
        return Lists.newArrayList();
    }
}

