/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.end_temple;

import com.mojang.serialization.Codec;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.config.StructureConfig;
import com.silverminer.shrines.structures.AbstractStructure;
import com.silverminer.shrines.structures.AbstractStructureStart;
import com.silverminer.shrines.structures.end_temple.EndTemplePiece;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndTempleStructure
extends AbstractStructure<NoFeatureConfig> {
    public EndTempleStructure(Codec<NoFeatureConfig> codec) {
        super(codec, 3, "end_temple");
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @Override
    public StructureConfig.StructureGenConfig getConfig() {
        return Config.STRUCTURES.END_TEMPLE;
    }

    @Override
    public boolean validateGeneration(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, IFeatureConfig config, Structure<?> ... exeptStructure) {
        boolean flag = super.validateGeneration(generator, provider, seed, rand, chunkX, chunkZ, biome, pos, config, exeptStructure);
        int offset = this.getSize() * 16;
        int xStart = chunkX << 4;
        int zStart = chunkZ << 4;
        int i1 = generator.func_222529_a(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222529_a(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222529_a(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222529_a(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        return flag && minHeight > 60;
    }

    @Override
    public boolean isEndStructure() {
        return true;
    }

    public static class Start
    extends AbstractStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingbox, int p_i225806_5_, long seed) {
            super(structure, chunkX, chunkZ, boundingbox, p_i225806_5_, seed);
        }

        public void generatePieces(DynamicRegistries registries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            BlockPos blockpos = new BlockPos(i, 0, j);
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            EndTemplePiece.generate(templateManager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

