/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.harbour;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.AbstractStructurePiece;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HarbourPieces {
    protected static final Logger LOG = LogManager.getLogger(HarbourPieces.class);
    protected static final ArrayList<ResourceLocation> GROUND = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p1"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p2"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p3"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p4"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p5"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p6"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p7"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p8"), new ResourceLocation("shrines:harbour/ground/harbour_ground_1_p9")});
    protected static final ResourceLocation HOUSE = new ResourceLocation("shrines:harbour/house1");
    protected static final ResourceLocation TAVERN = new ResourceLocation("shrines:harbour/tavern");
    protected static final ResourceLocation WARE = new ResourceLocation("shrines:harbour/ware1");
    protected static final ResourceLocation CRANE = new ResourceLocation("shrines:harbour/crane");
    protected static final ResourceLocation WAREHOUSE_BIG = new ResourceLocation("shrines:harbour/warehouse2");
    protected static final ArrayList<ResourceLocation> WAREHOUSE_SMALL = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:harbour/warehouse1"), new ResourceLocation("shrines:harbour/warehouse3")});
    protected static final ResourceLocation VILLAGER = new ResourceLocation("shrines:harbour/villager");
    protected static final ResourceLocation[] ZOMBIE = new ResourceLocation[]{new ResourceLocation("shrines:harbour/zombie_villager1"), new ResourceLocation("shrines:harbour/zombie_villager2"), new ResourceLocation("shrines:harbour/zombie_villager3"), new ResourceLocation("shrines:harbour/zombie_villager4"), new ResourceLocation("shrines:harbour/zombie_villager5")};

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random, ChunkGenerator chunkGenerator) {
        int height = HarbourPieces.getStartHeigth(pos, chunkGenerator) - 6;
        pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        LOG.info("Generating Harbourpieces on: {}, with height: {}", (Object)pos, (Object)height);
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(0), pos.func_177971_a((Vector3i)new BlockPos(0, 0, 0).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(1), pos.func_177971_a((Vector3i)new BlockPos(47, 0, 0).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(2), pos.func_177971_a((Vector3i)new BlockPos(94, 0, 0).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(3), pos.func_177971_a((Vector3i)new BlockPos(0, 0, 47).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(4), pos.func_177971_a((Vector3i)new BlockPos(47, 0, 47).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(5), pos.func_177971_a((Vector3i)new BlockPos(94, 0, 47).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(6), pos.func_177971_a((Vector3i)new BlockPos(0, 0, 94).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(7), pos.func_177971_a((Vector3i)new BlockPos(47, 0, 94).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourPiece(templateManager, GROUND.get(8), pos.func_177971_a((Vector3i)new BlockPos(94, 0, 94).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, HOUSE, pos.func_177971_a((Vector3i)new BlockPos(24, 0, 18).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_180), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, HOUSE, pos.func_177971_a((Vector3i)new BlockPos(7, 0, 45).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, HOUSE, pos.func_177971_a((Vector3i)new BlockPos(75, 0, 85).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, TAVERN, pos.func_177971_a((Vector3i)new BlockPos(20, 0, 47).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WARE, pos.func_177971_a((Vector3i)new BlockPos(43, 0, 15).func_190942_a(rotation)), rotation.func_185830_a(Rotation.NONE), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WARE, pos.func_177971_a((Vector3i)new BlockPos(70, 0, 25).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WARE, pos.func_177971_a((Vector3i)new BlockPos(97, 0, 43).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WARE, pos.func_177971_a((Vector3i)new BlockPos(54, 0, 57).func_190942_a(rotation)), rotation, 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(78, 0, 37).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_180), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(43, 0, 89).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_180), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(6, 0, 85).func_190942_a(rotation)), rotation.func_185830_a(Rotation.NONE), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(60, 0, 85).func_190942_a(rotation)), rotation.func_185830_a(Rotation.NONE), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(85, 0, 53).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, CRANE, pos.func_177971_a((Vector3i)new BlockPos(39, 0, 28).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_BIG, pos.func_177971_a((Vector3i)new BlockPos(64, 0, 8).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(20, 0, 98).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(57, 0, 90).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(85, 0, 9).func_190942_a(rotation)), rotation.func_185830_a(Rotation.CLOCKWISE_180), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(83, 0, 20).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(86, 0, 35).func_190942_a(rotation)), rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(47, 0, 63).func_190942_a(rotation)), rotation.func_185830_a(Rotation.NONE), 0, random, height));
        pieces.add((StructurePiece)new HarbourBuildingPiece(templateManager, WAREHOUSE_SMALL.get(random.nextInt(WAREHOUSE_SMALL.size())), pos.func_177971_a((Vector3i)new BlockPos(87, 0, 62).func_190942_a(rotation)), rotation.func_185830_a(Rotation.NONE), 0, random, height));
        LOG.debug("Starting villager generation");
        if (((Boolean)Config.STRUCTURES.HARBOUR.SPAWN_VILLAGERS.get()).booleanValue()) {
            int maxV = 20 + random.nextInt(20);
            boolean zombie = random.nextInt(10) == 0;
            for (int i = 0; i < maxV; ++i) {
                pieces.add((StructurePiece)new VillagerPiece(templateManager, zombie ? ZOMBIE[random.nextInt(ZOMBIE.length)] : VILLAGER, pos.func_177971_a((Vector3i)new BlockPos(random.nextInt(100), 0, random.nextInt(100)).func_190942_a(rotation)), rotation, 0, random));
            }
        }
    }

    protected static boolean areBoundingBoxesIntersecting(MutableBoundingBox mmb1, MutableBoundingBox structurebb) {
        return mmb1.field_78893_d >= structurebb.field_78897_a && mmb1.field_78897_a <= structurebb.field_78893_d && mmb1.field_78892_f >= structurebb.field_78896_c && mmb1.field_78896_c <= structurebb.field_78892_f;
    }

    protected static boolean checkFlatness(MutableBoundingBox mbb, ChunkGenerator chunkGenerator) {
        int minheight = 256;
        int maxheight = 0;
        for (int x = mbb.field_78897_a; x < mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z < mbb.field_78892_f; ++z) {
                int height = chunkGenerator.func_222529_a(x / 16, z / 16, Heightmap.Type.WORLD_SURFACE_WG);
                minheight = Math.min(minheight, height);
                maxheight = Math.max(maxheight, height);
            }
        }
        return Math.abs(maxheight - minheight) <= 4;
    }

    protected static int getStartHeigth(BlockPos pos, ChunkGenerator chunkGenerator) {
        MutableBoundingBox mbb = MutableBoundingBox.func_175899_a((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p(), (int)(pos.func_177958_n() + 100), (int)0, (int)(pos.func_177952_p() + 100));
        ArrayList<Integer> heigth = new ArrayList<Integer>();
        for (int x = mbb.field_78897_a; x < mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z < mbb.field_78892_f; ++z) {
                int surface = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE);
                boolean water = chunkGenerator.func_230348_a_(x / 16, z / 16).func_180495_p(new BlockPos(x, surface + 1, z)).func_177230_c() == Blocks.field_150355_j;
                heigth.add(water ? chunkGenerator.func_230356_f_() - 1 : surface - 1);
            }
        }
        return HarbourPieces.getAverage(heigth);
    }

    public static int getAverage(ArrayList<Integer> list) {
        double summe = 0.0;
        for (int index = 0; index < list.size(); ++index) {
            summe += (double)list.get(index).intValue();
        }
        if (list.size() > 0) {
            return (int)(summe / (double)list.size());
        }
        return 0;
    }

    public static class HarbourPiece
    extends ColorStructurePiece {
        protected int height;

        public HarbourPiece(TemplateManager templateManagerIn, ResourceLocation locationIn, BlockPos posIn, Rotation rotationIn, int componentTypeIn, Random rand, int height) {
            super(StructurePieceTypes.HARBOUR_GROUND, templateManagerIn, locationIn, posIn, rotationIn, componentTypeIn, false);
            this.height = height;
        }

        public HarbourPiece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.HARBOUR_GROUND, templateManager, cNBT);
            this.height = cNBT.func_74762_e("height");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("height", this.height);
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215206_c;
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.HARBOUR.USE_RANDOM_VARIANTING.get();
        }

        @Override
        protected int getHeight(ISeedReader world, BlockPos pos) {
            return this.height;
        }

        @Override
        public boolean validateBlock(BlockPos pos, BlockState newState, ISeedReader world, Random rand) {
            return newState.func_177230_c() == Blocks.field_150346_d && pos.func_177956_o() - 6 < this.getHeight(world, pos);
        }

        @Override
        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox mbb, ChunkPos chunkPos, BlockPos blockPos) {
            boolean flag = super.func_230383_a_(world, structureManager, chunkGen, rand, mbb, chunkPos, blockPos);
            BlockState newBlock = Blocks.field_150346_d.func_176223_P();
            for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150350_a)) {
                this.changeBlock(template$blockinfo.field_186242_a, newBlock, world, rand);
            }
            return flag;
        }
    }

    public static class HarbourBuildingPiece
    extends ColorStructurePiece {
        protected int height;
        protected int diamonds = 0;

        public HarbourBuildingPiece(TemplateManager templateManagerIn, ResourceLocation locationIn, BlockPos posIn, Rotation rotationIn, int componentTypeIn, Random rand, int height) {
            super(StructurePieceTypes.HARBOUR_HOUSE, templateManagerIn, locationIn, posIn, rotationIn, componentTypeIn, true);
            this.height = height;
        }

        public HarbourBuildingPiece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.HARBOUR_HOUSE, templateManager, cNBT);
            this.height = cNBT.func_74762_e("height");
            this.diamonds = cNBT.func_74762_e("diamonds");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("diamonds", this.diamonds);
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215204_a;
        }

        @Override
        public boolean overwriteOres() {
            return true;
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            super.func_186175_a(function, pos, worldIn, rand, sbb);
            boolean bl = loot = (Double)Config.STRUCTURES.HARBOUR.LOOT_CHANCE.get() > rand.nextDouble();
            if (function.equals("warehouse1_1")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
            }
            if (function.equals("warehouse1_2") || function.equals("warehouse1_3")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(1), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(3), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
            }
            if (function.equals("chest_tavern")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177979_c(2));
                if (tileentity instanceof LockableLootTileEntity) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR_TAVERN : ShrinesLootTables.EMPTY));
                } else {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(3), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR_TAVERN : ShrinesLootTables.EMPTY));
                }
            }
            if (function.equals("house1")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
            }
            if (function.equals("house1c")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
            }
            if (function.equals("house2")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(1), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
            }
            if (function.equals("house3")) {
                worldIn.func_180501_a(pos, worldIn.func_180495_p(pos.func_177977_b()), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(0), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(1), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot && rand.nextInt(6) == 0 ? HarbourBuildingPiece.getRandomHouseLoot(rand) : ShrinesLootTables.EMPTY));
            }
        }

        public static ResourceLocation getRandomHouseLoot(Random rand) {
            if (rand.nextInt(10) > 7) {
                return ShrinesLootTables.HARBOUR;
            }
            return ShrinesLootTables.HARBOUR_TAVERN;
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.HARBOUR.USE_RANDOM_VARIANTING.get();
        }

        @Override
        public boolean overwriteWool() {
            return false;
        }

        @Override
        protected int getHeight(ISeedReader world, BlockPos pos) {
            return this.height + 7;
        }

        @Override
        public boolean validateBlock(BlockPos pos, BlockState newState, ISeedReader world, Random rand) {
            if (newState.func_177230_c() == Blocks.field_150482_ag) {
                if (this.diamonds <= 16) {
                    ++this.diamonds;
                    return true;
                }
                if (this.COLORS.get(newState.func_177230_c()) == null) {
                    this.COLORS.put(newState.func_177230_c(), (Block)ORES.get(rand.nextInt(ORES.size())));
                }
                world.func_180501_a(pos, ((Block)this.COLORS.get(newState.func_177230_c())).func_176223_P(), 3);
                return false;
            }
            return true;
        }
    }

    public static class VillagerPiece
    extends AbstractStructurePiece {
        public VillagerPiece(TemplateManager templateManagerIn, ResourceLocation locationIn, BlockPos posIn, Rotation rotationIn, int componentTypeIn, Random rand) {
            super(StructurePieceTypes.HARBOUR_VILLAGER, templateManagerIn, locationIn, posIn, rotationIn, componentTypeIn);
        }

        public VillagerPiece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.HARBOUR_VILLAGER, templateManager, cNBT);
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215206_c;
        }

        @Override
        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox mbb, ChunkPos chunkPos, BlockPos blockPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a(this.getProcessor());
            BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3, 0, 0)));
            int i = this.getHeight(world, blockpos1);
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), i, this.field_186178_c.func_177952_p());
            BlockPos blockpos2 = this.field_186178_c;
            if (world.func_180495_p(blockpos2).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(blockpos2.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                super.func_230383_a_(world, structureManager, chunkGen, rand, mbb, chunkPos, this.field_186178_c);
                this.field_186178_c = blockpos2;
            }
            return true;
        }
    }
}

