/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.harbour;

import com.mojang.serialization.Codec;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.config.StructureConfig;
import com.silverminer.shrines.structures.AbstractStructure;
import com.silverminer.shrines.structures.AbstractStructureStart;
import com.silverminer.shrines.structures.harbour.HarbourPieces;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HarbourStructure
extends AbstractStructure<NoFeatureConfig> {
    public HarbourStructure(Codec<NoFeatureConfig> codec) {
        super(codec, 3, "harbour");
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @Override
    public StructureConfig.StructureGenConfig getConfig() {
        return Config.STRUCTURES.HARBOUR;
    }

    protected boolean isSurfaceFlatExtended(@Nonnull ChunkGenerator generator, int chunkX, int chunkZ) {
        int xStart = chunkX << 4;
        int zStart = chunkZ << 4;
        MutableBoundingBox mbb = MutableBoundingBox.func_175899_a((int)xStart, (int)0, (int)zStart, (int)(xStart + 100), (int)0, (int)(zStart + 100));
        int minheight = 256;
        int maxheight = 0;
        for (int x = mbb.field_78897_a; x < mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z < mbb.field_78892_f; ++z) {
                int height = generator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
                minheight = Math.min(minheight, height);
                maxheight = Math.max(maxheight, height);
            }
        }
        return maxheight - minheight <= 8;
    }

    @Override
    public boolean validateGeneration(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, IFeatureConfig config, Structure<?> ... exeptStructure) {
        if (super.validateGeneration(generator, provider, seed, rand, chunkX, chunkZ, biome, pos, config, exeptStructure)) {
            return this.isSurfaceFlatExtended(generator, chunkX, chunkZ);
        }
        return false;
    }

    public static class Start
    extends AbstractStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingbox, int p_i225806_5_, long seed) {
            super(structure, chunkX, chunkZ, boundingbox, p_i225806_5_, seed);
        }

        public void generatePieces(DynamicRegistries registries, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            BlockPos blockpos = new BlockPos(i, 0, j);
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            HarbourPieces.generate(templateManager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, chunkGenerator);
            this.func_202500_a();
        }
    }
}

