/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.harbour.test;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import com.silverminer.shrines.structures.harbour.test.HarbourHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterHarbourPieces {
    protected static final Logger LOG = LogManager.getLogger(BetterHarbourPieces.class);
    protected static List<StructurePiece> PIECES = null;
    protected static final ArrayList<MutableBoundingBox> mbbs = Lists.newArrayList();

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random, ChunkGenerator chunkGenerator) {
        PIECES = pieces;
        int height = HarbourHelper.getStartHeigth(pos, chunkGenerator) - 6;
        pos = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
        LOG.info("Generating Harbourpieces on: {}, with height: {}", (Object)pos, (Object)height);
        BlockPos ecke = new BlockPos(0, 0, 0);
        ArrayList bounds = Lists.newArrayList();
        int i = 1;
        while (i < 70) {
            for (int s = 1; s >= -1; s -= 2) {
                BlockPos position;
                ResourceLocation r;
                ecke = pos.func_177982_a(i * s, 0, i * s);
                for (int x = 0; x <= Math.abs(i * s * 2) && (r = BetterHarbourPieces.checkPos(position = new BlockPos(ecke.func_177958_n() + x * -s, 0, ecke.func_177952_p()), bounds, chunkGenerator, i)) != null; ++x) {
                    PIECES.add((StructurePiece)new HarbourBuildingPiece(templateManager, r, position, rotation, 0, random, height));
                }
                for (int z = 0; z <= Math.abs(i * s * 2) && (r = BetterHarbourPieces.checkPos(position = new BlockPos(ecke.func_177958_n(), 0, ecke.func_177952_p() + z * -s), bounds, chunkGenerator, i)) != null; ++z) {
                    PIECES.add((StructurePiece)new HarbourBuildingPiece(templateManager, r, position, rotation, 0, random, height));
                }
            }
            i = (int)Math.ceil((double)i * 1.25);
        }
        pieces = PIECES;
    }

    protected static ResourceLocation checkPos(BlockPos pos, ArrayList<MutableBoundingBox> bounds, ChunkGenerator cG, int distance) {
        ArrayList<ResourceLocation> pp = HarbourHelper.getPossiblePieces(distance);
        if (pp == null || pp.isEmpty()) {
            return null;
        }
        MutableBoundingBox mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
        ResourceLocation piece = null;
        for (ResourceLocation r : pp) {
            mbb = HarbourHelper.getBoundByPieces(r);
            mbb.func_78886_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (!BetterHarbourPieces.validatePiecePos(pos, mbb, cG)) continue;
            piece = r;
            break;
        }
        if (piece == null || mbb == null) {
            return null;
        }
        mbbs.add(mbb);
        return piece;
    }

    public static boolean validatePiecePos(BlockPos pos, MutableBoundingBox mbb, ChunkGenerator cG) {
        for (MutableBoundingBox m : mbbs) {
            if (!HarbourHelper.areBoundingBoxesIntersecting(m, mbb)) continue;
            return false;
        }
        for (int x = mbb.field_78897_a; x <= mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z <= mbb.field_78892_f; ++z) {
                int n = 0;
                BlockState state = cG.func_230348_a_(x, z).func_180495_p(new BlockPos(x, pos.func_177956_o() - n, z));
                while (!state.func_200132_m()) {
                    state = cG.func_230348_a_(x, z).func_180495_p(new BlockPos(x, pos.func_177956_o() - ++n, z));
                    LOG.info("Checking state {} for validation. It's block {}", (Object)state, (Object)state.func_177230_c());
                    if (n > 3) {
                        return false;
                    }
                    if (!(state.func_177230_c() instanceof FlowingFluidBlock)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static class HarbourBuildingPiece
    extends ColorStructurePiece {
        protected int height;
        protected int diamonds = 0;

        public HarbourBuildingPiece(TemplateManager templateManagerIn, ResourceLocation locationIn, BlockPos posIn, Rotation rotationIn, int componentTypeIn, Random rand, int height) {
            super(StructurePieceTypes.BETTER_HARBOUR, templateManagerIn, locationIn, posIn, rotationIn, componentTypeIn, true);
            this.height = height;
        }

        public HarbourBuildingPiece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.BETTER_HARBOUR, templateManager, cNBT);
            this.height = cNBT.func_74762_e("height");
            this.diamonds = cNBT.func_74762_e("diamonds");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("diamonds", this.diamonds);
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215204_a;
        }

        @Override
        public boolean overwriteOres() {
            return true;
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            boolean bl = loot = (Double)Config.STRUCTURES.HARBOUR.LOOT_CHANCE.get() > rand.nextDouble();
            if ((Double)Config.STRUCTURES.HARBOUR.LOOT_CHANCE.get() > rand.nextDouble()) {
                if (function.equals("warehouse1_1")) {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                }
                if (function.equals("warehouse1_2") || function.equals("warehouse1_3")) {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(1), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(3), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR : ShrinesLootTables.EMPTY));
                }
                if (function.equals("chest_tavern")) {
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    TileEntity tileentity = worldIn.func_175625_s(pos.func_177979_c(2));
                    if (tileentity instanceof LockableLootTileEntity) {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(2), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR_TAVERN : ShrinesLootTables.EMPTY));
                    } else {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(3), (ResourceLocation)(loot ? ShrinesLootTables.HARBOUR_TAVERN : ShrinesLootTables.EMPTY));
                    }
                }
            }
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.HARBOUR.USE_RANDOM_VARIANTING.get();
        }

        @Override
        public boolean overwriteWool() {
            return false;
        }

        @Override
        protected int getHeight(ISeedReader world, BlockPos pos) {
            return this.height + 7;
        }

        @Override
        public boolean validateBlock(BlockPos pos, BlockState newState, ISeedReader world, Random rand) {
            if (newState.func_177230_c() == Blocks.field_150482_ag) {
                if (this.diamonds <= 16) {
                    ++this.diamonds;
                    return true;
                }
                if (this.COLORS.get(newState.func_177230_c()) == null) {
                    this.COLORS.put(newState.func_177230_c(), (Block)ORES.get(rand.nextInt(ORES.size())));
                }
                world.func_180501_a(pos, ((Block)this.COLORS.get(newState.func_177230_c())).func_176223_P(), 3);
                return false;
            }
            return true;
        }
    }
}

