/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.harbour.test;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HarbourBallonPiece {
    private static final ArrayList<ResourceLocation> location = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:ballon/ballon_1"), new ResourceLocation("shrines:ballon/ballon_2"), new ResourceLocation("shrines:ballon/ballon_3"), new ResourceLocation("shrines:ballon/ballon_4"), new ResourceLocation("shrines:ballon/ballon_5"), new ResourceLocation("shrines:ballon/ballon_6"), new ResourceLocation("shrines:ballon/ballon_7"), new ResourceLocation("shrines:ballon/ballon2_1"), new ResourceLocation("shrines:ballon/ballon2_2"), new ResourceLocation("shrines:ballon/ballon2_3"), new ResourceLocation("shrines:ballon/ballon2_4")});

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        boolean flag = false;
        if (flag) {
            pieces.add((StructurePiece)new Piece(templateManager, location.get(random.nextInt(location.size())), pos, rotation, 0, random));
        } else {
            pieces.add((StructurePiece)new Piece(templateManager, location.get(0), pos, rotation, 0, random));
        }
    }

    public static class Piece
    extends ColorStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn, Random rand) {
            super(StructurePieceTypes.BALLON, templateManager, location, pos, rotation, componentTypeIn, true);
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.BALLON, templateManager, cNBT);
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215206_c;
        }

        @Override
        public boolean overwriteWool() {
            return true;
        }

        @Override
        public boolean overwriteWood() {
            return true;
        }

        @Override
        public boolean overwritePlanks() {
            return true;
        }

        @Override
        public boolean overwriteSlabs() {
            return true;
        }

        @Override
        public Block getDefaultPlank() {
            return Blocks.field_196664_o;
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.BALLON.USE_RANDOM_VARIANTING.get();
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ((Double)Config.STRUCTURES.BALLON.LOOT_CHANCE.get() > rand.nextDouble() && function.equals("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177981_b(2));
                if (tileentity instanceof BarrelTileEntity) {
                    ((BarrelTileEntity)tileentity).func_189404_a(ShrinesLootTables.BALLON, rand.nextLong());
                }
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox mbb, ChunkPos chunkPos, BlockPos pos) {
            BlockPos ecke = new BlockPos(0, 0, 0);
            int i = 1;
            while (i < 100) {
                for (int s = 1; s >= -1; s -= 2) {
                    BlockPos position;
                    ecke = pos.func_177982_a(i * s, 0, i * s);
                    for (int x = 0; x <= Math.abs(i * s * 2); ++x) {
                        position = new BlockPos(ecke.func_177958_n() + x * -s, 120, ecke.func_177952_p());
                        if (s == 1) {
                            world.func_180501_a(position, Blocks.field_150484_ah.func_176223_P(), 3);
                            continue;
                        }
                        world.func_180501_a(position, Blocks.field_150340_R.func_176223_P(), 3);
                    }
                    for (int z = 0; z <= Math.abs(i * s * 2); ++z) {
                        position = new BlockPos(ecke.func_177958_n(), 120, ecke.func_177952_p() + z * -s);
                        if (s == 1) {
                            world.func_180501_a(position, Blocks.field_235397_ng_.func_176223_P(), 3);
                            continue;
                        }
                        world.func_180501_a(position, Blocks.field_150339_S.func_176223_P(), 3);
                    }
                }
                i = (int)Math.ceil((double)i * 1.25);
            }
            return true;
        }
    }
}

