/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.harbour.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class HarbourHelper {
    public static final ResourceLocation HOUSE = new ResourceLocation("shrines:harbour/house1");
    public static final ResourceLocation TAVERN = new ResourceLocation("shrines:harbour/tavern");
    public static final ResourceLocation WARE = new ResourceLocation("shrines:harbour/ware1");
    public static final ResourceLocation CRANE = new ResourceLocation("shrines:harbour/crane");
    public static final ResourceLocation WAREHOUSE_BIG = new ResourceLocation("shrines:harbour/warehouse2");
    public static final ArrayList<ResourceLocation> WAREHOUSE_SMALL = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:harbour/warehouse1"), new ResourceLocation("shrines:harbour/warehouse3")});
    public static final ResourceLocation VILLAGER = new ResourceLocation("shrines:harbour/villager");

    public static MutableBoundingBox getBoundByPieces(ResourceLocation r) {
        MutableBoundingBox mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
        switch (r.toString().replace("shrines:harbour/", "")) {
            case "crane": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)5, (int)10, (int)14);
                break;
            }
            case "house1": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)19, (int)16, (int)12);
                break;
            }
            case "tavern": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)25, (int)28, (int)23);
                break;
            }
            case "ware1": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)5, (int)3, (int)5);
                break;
            }
            case "warehouse1": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)11, (int)6, (int)10);
                break;
            }
            case "warehouse2": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)15, (int)10, (int)11);
                break;
            }
            case "warehouse3": {
                mbb = MutableBoundingBox.func_175899_a((int)0, (int)0, (int)0, (int)11, (int)6, (int)10);
            }
        }
        return mbb;
    }

    public static ArrayList<ResourceLocation> getPossiblePieces(int i) {
        ArrayList pieces = Lists.newArrayList();
        if (i < 10) {
            pieces = Lists.newArrayList((Object[])new ResourceLocation[]{CRANE, WARE});
        } else if (i < 20) {
            pieces = Lists.newArrayList((Object[])new ResourceLocation[]{CRANE, WARE});
            pieces.addAll(WAREHOUSE_SMALL);
        } else if (i < 25) {
            pieces = Lists.newArrayList((Object[])new ResourceLocation[]{CRANE, WAREHOUSE_BIG, WARE});
            pieces.addAll(WAREHOUSE_SMALL);
        } else {
            pieces = i < 35 ? Lists.newArrayList((Object[])new ResourceLocation[]{WAREHOUSE_BIG, HOUSE}) : Lists.newArrayList((Object[])new ResourceLocation[]{HOUSE, TAVERN});
        }
        return pieces;
    }

    public static boolean areBoundingBoxesIntersecting(MutableBoundingBox mmb1, MutableBoundingBox structurebb) {
        return mmb1.field_78893_d >= structurebb.field_78897_a && mmb1.field_78897_a <= structurebb.field_78893_d && mmb1.field_78892_f >= structurebb.field_78896_c && mmb1.field_78896_c <= structurebb.field_78892_f;
    }

    public static boolean checkFlatness(MutableBoundingBox mbb, ChunkGenerator chunkGenerator) {
        int minheight = 256;
        int maxheight = 0;
        for (int x = mbb.field_78897_a; x < mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z < mbb.field_78892_f; ++z) {
                int height = chunkGenerator.func_222529_a(x / 16, z / 16, Heightmap.Type.WORLD_SURFACE_WG);
                minheight = Math.min(minheight, height);
                maxheight = Math.max(maxheight, height);
            }
        }
        return Math.abs(maxheight - minheight) <= 4;
    }

    public static int getStartHeigth(BlockPos pos, ChunkGenerator chunkGenerator) {
        MutableBoundingBox mbb = MutableBoundingBox.func_175899_a((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p(), (int)(pos.func_177958_n() + 100), (int)0, (int)(pos.func_177952_p() + 100));
        ArrayList<Integer> heigth = new ArrayList<Integer>();
        for (int x = mbb.field_78897_a; x < mbb.field_78893_d; ++x) {
            for (int z = mbb.field_78896_c; z < mbb.field_78892_f; ++z) {
                int surface = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE);
                boolean water = chunkGenerator.func_230348_a_(x / 16, z / 16).func_180495_p(new BlockPos(x, surface + 1, z)).func_177230_c() == Blocks.field_150355_j;
                heigth.add(water ? chunkGenerator.func_230356_f_() - 1 : surface - 1);
            }
        }
        return HarbourHelper.getAverage(heigth);
    }

    public static int getAverage(ArrayList<Integer> list) {
        double summe = 0.0;
        for (int index = 0; index < list.size(); ++index) {
            summe += (double)list.get(index).intValue();
        }
        if (list.size() > 0) {
            return (int)(summe / (double)list.size());
        }
        return 0;
    }
}

