/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.high_tempel;

import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HighTempelPiece {
    private static final ResourceLocation location = new ResourceLocation("shrines:high_tempel/high_tempel");

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        pieces.add((StructurePiece)new Piece(templateManager, location, pos, rotation, 0));
    }

    public static class Piece
    extends ColorStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn) {
            super(StructurePieceTypes.HIGH_TEMPEL, templateManager, location, pos, rotation, componentTypeIn, true);
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.HIGH_TEMPEL, templateManager, cNBT);
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            super.func_186175_a(function, pos, worldIn, rand, sbb);
            boolean bl = loot = (Double)Config.STRUCTURES.HIGH_TEMPEL.LOOT_CHANCE.get() > rand.nextDouble();
            if (function.equals("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.HIGH_TEMPEL : ShrinesLootTables.EMPTY));
            }
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.HIGH_TEMPEL.USE_RANDOM_VARIANTING.get();
        }

        @Override
        public Block getDefaultPlank() {
            return Blocks.field_196672_s;
        }

        @Override
        public boolean overwriteWool() {
            return false;
        }

        @Override
        public boolean overwriteTerracotta() {
            return false;
        }

        @Override
        public boolean overwriteGlazedTerracotta() {
            return false;
        }
    }
}

