/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.nether_pyramid;

import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NetherPyramidPiece {
    private static final ResourceLocation location = new ResourceLocation("shrines:nether_pyramid/nether_pyramid");

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        pieces.add((StructurePiece)new Piece(templateManager, location, pos.func_177982_a(0, -1, 0), rotation, 0));
    }

    public static class Piece
    extends ColorStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn) {
            super(StructurePieceTypes.NETHER_PYRAMID, templateManager, location, pos, rotation, componentTypeIn, false);
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.NETHER_PYRAMID, templateManager, cNBT);
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            boolean bl = loot = (Double)Config.STRUCTURES.NETHER_PYRAMID.LOOT_CHANCE.get() > rand.nextDouble();
            if ("chest_left".equals(function) || "chest_right".equals(function) || "chest_d1".equals(function) || "chest_d2".equals(function) || "chest_d3".equals(function) || "chest_d4".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.getRandomNetherLoot(rand) : ShrinesLootTables.EMPTY));
            }
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.NETHER_PYRAMID.USE_RANDOM_VARIANTING.get();
        }

        @Override
        public boolean overwriteStone() {
            return true;
        }

        @Override
        public boolean overwriteStairs() {
            return true;
        }

        @Override
        public boolean overwriteSlabs() {
            return true;
        }

        @Override
        public float getStoneChangeChance() {
            return 0.15f;
        }
    }
}

