/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.nether_shrine;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NetherShrinePiece {
    private static final ArrayList<ResourceLocation> location = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:nether_shrine/nether_shrine_001"), new ResourceLocation("shrines:nether_shrine/nether_shrine_002"), new ResourceLocation("shrines:nether_shrine/nether_shrine_003"), new ResourceLocation("shrines:nether_shrine/nether_shrine_004"), new ResourceLocation("shrines:nether_shrine/nether_shrine_005"), new ResourceLocation("shrines:nether_shrine/nether_shrine_006"), new ResourceLocation("shrines:nether_shrine/nether_shrine_007"), new ResourceLocation("shrines:nether_shrine/nether_shrine_008"), new ResourceLocation("shrines:nether_shrine/nether_shrine_009"), new ResourceLocation("shrines:nether_shrine/nether_shrine_010"), new ResourceLocation("shrines:nether_shrine/nether_shrine_011")});

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        pieces.add((StructurePiece)new Piece(templateManager, location.get(random.nextInt(location.size())), pos, rotation, 0));
    }

    public static class Piece
    extends ColorStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn) {
            super(StructurePieceTypes.NETHER_SHRINE, templateManager, location, pos, rotation, componentTypeIn, true);
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.NETHER_SHRINE, templateManager, cNBT);
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            boolean bl = loot = (Double)Config.STRUCTURES.NETHER_SHRINE.LOOT_CHANCE.get() > rand.nextDouble();
            if ("chest1".equals(function) || "chest2".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.getRandomNetherLoot(rand) : ShrinesLootTables.EMPTY));
            }
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.NETHER_SHRINE.USE_RANDOM_VARIANTING.get();
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215206_c;
        }

        @Override
        public float getStoneChangeChance() {
            return 0.2f;
        }
    }
}

