/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.player_house;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PlayerhousePiece {
    private static final ArrayList<ResourceLocation> location = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:player_house/player_house_1"), new ResourceLocation("shrines:player_house/player_house_2"), new ResourceLocation("shrines:player_house/player_house_3"), new ResourceLocation("shrines:player_house/player_house_spruce_table_1"), new ResourceLocation("shrines:player_house/player_house_spruce_table_2"), new ResourceLocation("shrines:player_house/player_house_table")});
    private static final ArrayList<ResourceLocation> v2_location = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:player_house/player_house_v2_1")});

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        boolean flag = true;
        if (flag) {
            if (random.nextInt(2) == 0) {
                pieces.add((StructurePiece)new Piece(templateManager, location.get(random.nextInt(location.size())), pos, rotation, 0, true, 1));
            } else {
                pieces.add((StructurePiece)new Piece(templateManager, v2_location.get(random.nextInt(v2_location.size())), pos, rotation, 0, true, 2));
            }
        } else {
            pieces.add((StructurePiece)new Piece(templateManager, location.get(location.size() - 1), pos, rotation, 0, true, 0));
        }
    }

    public static class Piece
    extends ColorStructurePiece {
        public int v = 0;

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn, boolean defaultValue, int vIn) {
            super(StructurePieceTypes.PLAYER_HOUSE, templateManager, location, pos, rotation, componentTypeIn, defaultValue);
            this.v = vIn;
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.PLAYER_HOUSE, templateManager, cNBT);
            this.v = cNBT.func_74762_e("version");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("version", this.v);
        }

        @Override
        public Block getDefaultPlank() {
            if (this.v == 2) {
                return Blocks.field_196664_o;
            }
            return Blocks.field_196662_n;
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215204_a;
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.PLAYER_HOUSE.USE_RANDOM_VARIANTING.get();
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot = (Double)Config.STRUCTURES.PLAYER_HOUSE.LOOT_CHANCE.get() > rand.nextDouble();
            boolean chest2 = "chest_2".equals(function);
            if ("chest".equals(function) || chest2) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                BlockPos position = chest2 ? pos.func_177979_c(5) : pos.func_177977_b();
                if (rand.nextInt(6) == 0) {
                    if (rand.nextInt(2) == 0) {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)position, (ResourceLocation)(loot ? ShrinesLootTables.HOUSE_OP : ShrinesLootTables.EMPTY));
                    } else {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)position, (ResourceLocation)(loot ? ShrinesLootTables.HOUSE_OP_2 : ShrinesLootTables.EMPTY));
                    }
                } else {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)position, (ResourceLocation)(loot ? ShrinesLootTables.getRandomVillageLoot(rand) : ShrinesLootTables.EMPTY));
                }
            }
            if ("chest_furnace".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                if (rand.nextInt(2) == 0) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.FURNACE : ShrinesLootTables.EMPTY));
                } else {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.FURNACE_2 : ShrinesLootTables.EMPTY));
                }
            }
        }
    }
}

