/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.witch_house;

import com.google.common.collect.Lists;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.loot_tables.ShrinesLootTables;
import com.silverminer.shrines.structures.ColorStructurePiece;
import com.silverminer.shrines.structures.StructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AbandonedWitchHousePiece {
    private static final ArrayList<ResourceLocation> location = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("shrines:witch_house/abandoned_witch_house")});

    public static void generate(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random) {
        pieces.add((StructurePiece)new Piece(templateManager, location.get(random.nextInt(location.size())), pos, rotation, 0, true));
    }

    public static class Piece
    extends ColorStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn, boolean defaultValue) {
            super(StructurePieceTypes.WITCH_HOUSE, templateManager, location, pos, rotation, componentTypeIn, defaultValue);
        }

        public Piece(TemplateManager templateManager, CompoundNBT cNBT) {
            super(StructurePieceTypes.WITCH_HOUSE, templateManager, cNBT);
        }

        @Override
        public Block getDefaultPlank() {
            return Blocks.field_196664_o;
        }

        @Override
        public StructureProcessor getProcessor() {
            return BlockIgnoreStructureProcessor.field_215204_a;
        }

        @Override
        protected boolean useRandomVarianting() {
            return (Boolean)Config.STRUCTURES.WITCH_HOUSE.USE_RANDOM_VARIANTING.get();
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            boolean loot;
            boolean bl = loot = (Double)Config.STRUCTURES.WITCH_HOUSE.LOOT_CHANCE.get() > rand.nextDouble();
            if (function.equals("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177979_c(3), (ResourceLocation)(loot ? ShrinesLootTables.WITCH_HOUSE : ShrinesLootTables.EMPTY));
            }
            if (function.equals("chest_cobweb")) {
                worldIn.func_180501_a(pos, Blocks.field_196553_aF.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.WITCH_HOUSE : ShrinesLootTables.EMPTY));
            }
            if (function.equals("chest_op")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(loot ? ShrinesLootTables.WITCH_HOUSE : ShrinesLootTables.EMPTY));
            }
        }
    }
}

