/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.utils;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.FileUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModTemplateManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, Template> structureRepository = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final Path generatedDir;

    public ModTemplateManager(Path path, DataFixer p_i232119_3_) {
        this.fixerUpper = p_i232119_3_;
        this.generatedDir = path.normalize();
        LOGGER.info("Constructing mod template manager with file: {}", (Object)this.generatedDir);
    }

    public Template getOrCreate(ResourceLocation p_200220_1_) {
        Template template = this.get(p_200220_1_);
        if (template == null) {
            template = new Template();
            this.structureRepository.put(p_200220_1_, template);
        }
        return template;
    }

    @Nullable
    public Template get(ResourceLocation resourcelocation) {
        return this.structureRepository.computeIfAbsent(resourcelocation, p_209204_1_ -> {
            Template template = this.loadFromGenerated((ResourceLocation)p_209204_1_);
            return template;
        });
    }

    @Nullable
    private Template loadFromGenerated(ResourceLocation p_195428_1_) {
        Template template;
        if (!this.generatedDir.toFile().isDirectory()) {
            return null;
        }
        Path path = this.createAndValidatePathToStructure(p_195428_1_, ".nbt");
        LOGGER.debug("Loading custom structure piece from {}", (Object)path);
        FileInputStream inputstream = new FileInputStream(path.toFile());
        try {
            template = this.readStructure(inputstream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputstream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException filenotfoundexception) {
                LOGGER.warn("Couldn't load structure from {}, because of {}", (Object)path, (Object)filenotfoundexception);
                return null;
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't load structure from {}", (Object)path, (Object)ioexception);
                return null;
            }
        }
        ((InputStream)inputstream).close();
        return template;
    }

    private Template readStructure(InputStream p_209205_1_) throws IOException {
        CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a((InputStream)p_209205_1_);
        return this.readStructure(compoundnbt);
    }

    public Template readStructure(CompoundNBT p_227458_1_) {
        if (!p_227458_1_.func_150297_b("DataVersion", 99)) {
            p_227458_1_.func_74768_a("DataVersion", 500);
        }
        Template template = new Template();
        template.func_186256_b(NBTUtil.func_210822_a((DataFixer)this.fixerUpper, (DefaultTypeReferences)DefaultTypeReferences.STRUCTURE, (CompoundNBT)p_227458_1_, (int)p_227458_1_.func_74762_e("DataVersion")));
        return template;
    }

    public Path createPathToStructure(ResourceLocation p_209509_1_, String p_209509_2_) {
        try {
            Path path = this.generatedDir.resolve(p_209509_1_.func_110624_b());
            return FileUtil.func_214993_b((Path)path, (String)p_209509_1_.func_110623_a(), (String)p_209509_2_);
        }
        catch (InvalidPathException invalidpathexception) {
            throw new ResourceLocationException("Invalid resource path: " + p_209509_1_, (Throwable)invalidpathexception);
        }
    }

    private Path createAndValidatePathToStructure(ResourceLocation p_209510_1_, String p_209510_2_) {
        if (p_209510_1_.func_110623_a().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + p_209510_1_);
        }
        Path path = this.createPathToStructure(p_209510_1_, p_209510_2_);
        if (path.startsWith(this.generatedDir) && FileUtil.func_214995_a((Path)path) && FileUtil.func_214994_b((Path)path)) {
            return path;
        }
        throw new ResourceLocationException("Invalid resource path: " + path);
    }

    public void remove(ResourceLocation p_189941_1_) {
        this.structureRepository.remove(p_189941_1_);
    }
}

