/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.utils;

import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    public static final Logger LOGGER = LogManager.getLogger(Utils.class);
    public static ArrayList<String> customsToDelete = new ArrayList();
    public static ArrayList<CustomStructureData> customsStructs = new ArrayList();

    public static void loadCustomStructures() {
        try {
            File structures;
            DistExecutor.SafeSupplier<String> client = new DistExecutor.SafeSupplier<String>(){
                private static final long serialVersionUID = 1L;

                public String get() {
                    return Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
                }
            };
            DistExecutor.SafeSupplier<String> server = new DistExecutor.SafeSupplier<String>(){
                private static final long serialVersionUID = 1L;

                public String get() {
                    try {
                        return FMLPaths.GAMEDIR.get().toFile().getCanonicalFile().getAbsolutePath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return "";
                    }
                }
            };
            String path = (String)DistExecutor.safeRunForDist(() -> Utils.lambda$loadCustomStructures$0((DistExecutor.SafeSupplier)client), () -> Utils.lambda$loadCustomStructures$1((DistExecutor.SafeSupplier)server));
            File f = new File(path, "shrines-saves").getCanonicalFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!(structures = new File(f, "structures.txt")).exists()) {
                structures.createNewFile();
            }
            List<String> names = Files.readAllLines(structures.toPath());
            Random rand = new Random();
            for (String n : names) {
                if (n.startsWith("#")) continue;
                File st = new File(f, "shrines");
                if (!(st = new File(st, n)).isDirectory()) {
                    st.mkdirs();
                }
                st = new File(st, n + ".txt");
                CustomStructureData csd = new CustomStructureData(n, rand);
                if (!st.exists()) {
                    st.createNewFile();
                    FileWriter fw = new FileWriter(st);
                    fw.write(csd.toString().replaceAll(";", ";\n"));
                    fw.close();
                }
                String data = "";
                for (String s : Files.readAllLines(st.toPath())) {
                    data = data + s + "\n";
                }
                csd.fromString(data);
                customsStructs.add(csd);
                LOGGER.info("Read config of [{}] from file: {}", (Object)n, (Object)csd.toString());
            }
            LOGGER.info("Read structures from: {}", (Object)f);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static CustomStructureData getData(String name) {
        for (CustomStructureData csd : customsStructs) {
            if (!csd.getName().equals(name)) continue;
            return csd;
        }
        return null;
    }

    private static /* synthetic */ DistExecutor.SafeSupplier lambda$loadCustomStructures$1(DistExecutor.SafeSupplier server) {
        return server;
    }

    private static /* synthetic */ DistExecutor.SafeSupplier lambda$loadCustomStructures$0(DistExecutor.SafeSupplier client) {
        return client;
    }
}

