/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.config;

import com.cgessinger.creaturesandbeasts.common.config.EntityConfig;
import com.cgessinger.creaturesandbeasts.common.config.OtherConfig;
import com.google.common.collect.Lists;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="cnb", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CNBConfig {
    public static final ServerConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void bakeConfig() {
        ServerConfig.GREBE_CONFIG.bake();
        ServerConfig.LIZARD_CONFIG.bake();
        ServerConfig.CINDERSHELL_CONFIG.bake();
        ServerConfig.FRIENDLY_SPORELING_CONFIG.bake();
        ServerConfig.HOSTILE_SPORELING_CONFIG.bake();
        ServerConfig.NEUTRAL_SPORELING_CONFIG.bake();
        ServerConfig.LILYTAD_CONFIG.bake();
        ServerConfig.YETI_CONFIG.bake();
        ServerConfig.YETI_PROP.bake();
        ServerConfig.HIDE_AMOUNT.bake();
        ServerConfig.HIDE_MULTIPLIER.bake();
        ServerConfig.HIDE_COST.bake();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        CNBConfig.bakeConfig();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public static EntityConfig GREBE_CONFIG;
        public static EntityConfig LIZARD_CONFIG;
        public static EntityConfig CINDERSHELL_CONFIG;
        public static EntityConfig FRIENDLY_SPORELING_CONFIG;
        public static EntityConfig HOSTILE_SPORELING_CONFIG;
        public static EntityConfig NEUTRAL_SPORELING_CONFIG;
        public static EntityConfig LILYTAD_CONFIG;
        public static EntityConfig YETI_CONFIG;
        public static OtherConfig<Double> YETI_PROP;
        public static OtherConfig<Integer> HIDE_AMOUNT;
        public static OtherConfig<Double> HIDE_MULTIPLIER;
        public static OtherConfig<Integer> HIDE_COST;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("cnb").comment("Creatures And Beasts common config");
            builder.push("cnb_entity").comment("Creatures And Beasts Entity Config");
            GREBE_CONFIG = EntityConfig.createConfigForEntity(builder, "grebe", true, 30, Lists.newArrayList((Object[])new String[]{"minecraft:frozen_river", "minecraft:river"}));
            LIZARD_CONFIG = EntityConfig.createConfigForEntity(builder, "lizard", true, 50, Lists.newArrayList((Object[])new String[]{"minecraft:badlands", "minecraft:wooded_badlands_plateau", "minecraft:badlands_plateau", "minecraft:desert", "minecraft:desert_hills", "minecraft:desert_lakes"}));
            CINDERSHELL_CONFIG = EntityConfig.createConfigForEntity(builder, "cindershell", true, 10, Lists.newArrayList((Object[])new String[]{"minecraft:soul_sand_valley", "minecraft:crimson_forest", "minecraft:warped_forest", "minecraft:basalt_deltas", "minecraft:nether_wastes"}));
            FRIENDLY_SPORELING_CONFIG = EntityConfig.createConfigForEntity(builder, "friendly_sporeling", true, 40, Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_fields", "minecraft:mushroom_field_shore", "minecraft:dark_forest", "minecraft:swamp", "minecraft:swamp_hills"}));
            HOSTILE_SPORELING_CONFIG = EntityConfig.createConfigForEntity(builder, "hostile_sporeling", true, 10, Lists.newArrayList((Object[])new String[]{"minecraft:soul_sand_valley", "minecraft:basalt_deltas", "minecraft:nether_wastes"}));
            NEUTRAL_SPORELING_CONFIG = EntityConfig.createConfigForEntity(builder, "neutral_sporeling", true, 5, Lists.newArrayList((Object[])new String[]{"minecraft:crimson_forest", "minecraft:warped_forest"}));
            LILYTAD_CONFIG = EntityConfig.createConfigForEntity(builder, "lilytad", true, 35, Lists.newArrayList((Object[])new String[]{"minecraft:swamp", "minecraft:swamp_hills"}));
            YETI_CONFIG = EntityConfig.createConfigForEntity(builder, "yeti", true, 1, Lists.newArrayList((Object[])new String[]{"minecraft:snowy_tundra", "minecraft:snowy_mountains", "minecraft:snowy_taiga", "minecraft:snowy_taiga_hills", "minecraft:ice_spikes", "minecraft:snowy_taiga_mountains"}));
            YETI_PROP = OtherConfig.withRange(builder, "Define extra chance to spawn yeti. Each time a yeti should spawn it checks random.nextFloat() >= value. Increase this value up to 1.0 to make yetis more rare", "yeti chance", 0.5, 0.0, 1.0, Double.class);
            builder.pop();
            builder.push("cnb_other").comment("Creatures And Beasts Other Config");
            HIDE_AMOUNT = OtherConfig.with(builder, "Define how often items can be reinforced with the yeti hide", "hide amount", 5);
            HIDE_MULTIPLIER = OtherConfig.with(builder, "Define the yeti hide reinforcement multiplier. The armor attribute value will be multiplied with this value each time", "hide multiplier", 1.01);
            HIDE_COST = OtherConfig.with(builder, "Define amount of xp needed to upgrade armor with yeti hide", "hide cost", 1);
            builder.pop();
            builder.pop();
        }
    }
}

