/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.entites;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.goals.AnimatedAttackGoal;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import com.cgessinger.creaturesandbeasts.common.interfaces.IAnimationHolder;
import com.cgessinger.creaturesandbeasts.common.util.AnimationHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class YetiEntity
extends AnimalEntity
implements IAnimatable,
IAnimationHolder<YetiEntity>,
IMob {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    private final float babyHealth = 20.0f;
    public static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(YetiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> EAT = EntityDataManager.func_187226_a(YetiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<ItemStack> HOLDING = EntityDataManager.func_187226_a(YetiEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public AnimationHandler<YetiEntity> attackHandler = new AnimationHandler<YetiEntity>("attack_controller", this, 35, 17, 5, ATTACKING);
    public AnimationHandler<YetiEntity> eatHandler = new AnimationHandler<YetiEntity>("breed_controller", this, 40, 10, 20, EAT);
    public boolean isPassive;

    public YetiEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 16.0).func_233815_a_(Attributes.field_233825_h_, 0.1).func_233815_a_(Attributes.field_233820_c_, 0.7);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(EAT, (Object)false);
        this.field_70180_af.func_187214_a(HOLDING, (Object)ItemStack.field_190927_a);
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        double MAX_HEALTH = this.func_110148_a(Attributes.field_233818_a_).func_111126_e();
        if (this.func_70631_g_()) {
            Objects.requireNonNull(this);
            if (MAX_HEALTH > 20.0) {
                HashMultimap multimap = HashMultimap.create();
                Objects.requireNonNull(this);
                multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", 20.0 - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
                this.func_233645_dx_().func_233793_b_((Multimap)multimap);
                this.func_70606_j(this.babyHealth);
            }
        }
    }

    protected void func_175500_n() {
        super.func_175500_n();
        this.func_110148_a(Attributes.field_233818_a_).func_188479_b(this.healthReductionUUID);
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("passive", this.isPassive);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("passive")) {
            this.isPassive = compound.func_74767_n("passive");
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (((Boolean)this.field_70180_af.func_187225_a(EAT)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.func_70631_g_() ? "yeti_baby.eat" : "yeti_adult.eat", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("yeti.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (!(this.field_70721_aZ > -0.15f) || !(this.field_70721_aZ < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("yeti.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("yeti.idle", Boolean.valueOf(false)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        player.func_184185_a((SoundEvent)ModSoundEventTypes.YETI_HIT.get(), 0.4f, 1.0f);
    }

    private <E extends IAnimatable> void particleListener(ParticleKeyFrameEvent<E> event) {
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        BlockPos pos = this.func_233580_cy_();
        if ("hit.ground.particle".equals(event.effect)) {
            for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                    BlockPos newPos = new BlockPos(x, pos.func_177956_o() - 1, z);
                    manager.func_180533_a(newPos, this.field_70170_p.func_180495_p(newPos));
                }
            }
        } else if ("eat.particle".equals(event.effect)) {
            this.spawnParticles((IParticleData)ParticleTypes.field_197632_y);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)ModEntityTypes.YETI.get()).func_200721_a((World)p_241840_1_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimatedAttackGoal<YetiEntity>(this, 1.2, true){

            public boolean func_75253_b() {
                return super.func_75253_b() && !((YetiEntity)this.field_75441_b).isPassive;
            }

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !((YetiEntity)this.field_75441_b).isPassive;
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.01f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate);
        controller.registerSoundListener(this::soundListener);
        controller.registerParticleListener(this::particleListener);
        animationData.addAnimationController(controller);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EAT);
    }

    @Override
    public AnimationHandler<YetiEntity> getAnimationHandler(String name) {
        if (name.equals("attack_controller")) {
            return this.attackHandler;
        }
        return this.eatHandler;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (((Boolean)this.field_70180_af.func_187225_a(EAT)).booleanValue()) {
            this.field_70699_by.func_75499_g();
        }
        this.attackHandler.process();
        this.eatHandler.process();
    }

    @Override
    public Optional<AnimationHandler.ExecutionData> onAnimationInit(Optional<AnimationHandler.ExecutionData> data) {
        this.func_70661_as().func_75499_g();
        return IAnimationHolder.super.onAnimationInit(data);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void executeAttack() {
        for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0))) {
            if (entity instanceof YetiEntity) continue;
            this.func_70652_k((Entity)entity);
        }
    }

    @Override
    public void executeBreakpoint(Optional<AnimationHandler.ExecutionData> data) {
        if (data.isPresent()) {
            AnimationHandler.ExecutionData execData = data.get();
            if (execData.name.equals(this.attackHandler.name)) {
                this.executeAttack();
            } else if (execData.name.equals(this.eatHandler.name)) {
                if (this.func_70631_g_()) {
                    this.func_175501_a((int)((float)(-this.func_70874_b()) / 20.0f * 0.1f), true);
                } else if (this.getHolding().func_77973_b() == Items.field_222112_pR) {
                    this.func_146082_f(execData.player);
                } else {
                    this.func_70624_b(null);
                    this.isPassive = true;
                }
                this.setHolding(ItemStack.field_190927_a);
            }
        }
    }

    public void setHolding(ItemStack stack) {
        this.field_70180_af.func_187227_b(HOLDING, (Object)stack);
    }

    public ItemStack getHolding() {
        return (ItemStack)this.field_70180_af.func_187225_a(HOLDING);
    }

    public ActionResultType tryStartEat(PlayerEntity player, ItemStack stack) {
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (this.eatHandler.canStart()) {
            if (stack.func_77973_b() == Items.field_151127_ba && !this.isPassive) {
                return this.startEat(player, stack);
            }
            if (stack.func_77973_b() == Items.field_222112_pR && (this.func_70874_b() == 0 && this.func_204701_dC() || this.func_70631_g_())) {
                return this.startEat(player, stack);
            }
        }
        return ActionResultType.PASS;
    }

    private ActionResultType startEat(PlayerEntity player, ItemStack stack) {
        this.setHolding(stack);
        this.func_175505_a(player, stack);
        this.eatHandler.startAnimation(AnimationHandler.ExecutionData.create().withPlayer(player).build());
        SoundEvent sound = this.func_70631_g_() ? (SoundEvent)ModSoundEventTypes.YETI_BABY_EAT.get() : (SoundEvent)ModSoundEventTypes.YETI_ADULT_EAT.get();
        this.func_184185_a(sound, 1.1f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        super.func_230254_b_(player, hand);
        ItemStack item = player.func_184586_b(hand);
        return this.tryStartEat(player, item);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public void spawnParticles(IParticleData data) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(data, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_70631_g_()) {
            List list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
            for (YetiEntity yeti : list) {
                if (yeti.func_70631_g_()) continue;
                yeti.isPassive = false;
                break;
            }
        }
        this.isPassive = false;
        return super.func_70097_a(source, amount);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (!blockIn.func_185904_a().func_76224_d()) {
            this.func_184185_a((SoundEvent)ModSoundEventTypes.YETI_STEP.get(), this.func_70599_aP() * 0.3f, this.func_70647_i());
        }
    }

    protected float func_70647_i() {
        float pitch = super.func_70647_i();
        return this.func_70631_g_() ? pitch * 1.5f : pitch;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? null : (SoundEvent)ModSoundEventTypes.YETI_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? null : (SoundEvent)ModSoundEventTypes.YETI_HURT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70631_g_() ? null : (SoundEvent)ModSoundEventTypes.YETI_HURT.get();
    }

    public void func_70623_bb() {
        if (!CNBConfig.ServerConfig.YETI_CONFIG.shouldExist) {
            this.func_70106_y();
            return;
        }
        super.func_70623_bb();
    }

    public static boolean canYetiSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return random.nextDouble() >= (Double)CNBConfig.ServerConfig.YETI_PROP.value;
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)YetiEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (!YetiEntity.this.func_70631_g_() && super.func_75250_a()) {
                for (YetiEntity yeti : YetiEntity.this.field_70170_p.func_217357_a(YetiEntity.class, YetiEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!yeti.func_70631_g_() || YetiEntity.this.isPassive) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

