/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.world.gen;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.config.EntityConfig;
import com.cgessinger.creaturesandbeasts.common.entites.CindershellEntity;
import com.cgessinger.creaturesandbeasts.common.entites.FriendlySporelingEntity;
import com.cgessinger.creaturesandbeasts.common.entites.GrebeEntity;
import com.cgessinger.creaturesandbeasts.common.entites.HostileSporelingEntity;
import com.cgessinger.creaturesandbeasts.common.entites.LilytadEntity;
import com.cgessinger.creaturesandbeasts.common.entites.LizardEntity;
import com.cgessinger.creaturesandbeasts.common.entites.NeutralSporelingEntity;
import com.cgessinger.creaturesandbeasts.common.entites.YetiEntity;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cnb")
public class ModEntitySpawns {
    @SubscribeEvent
    public static void spawnEntities(BiomeLoadingEvent event) {
        String biomeName = event.getName().toString();
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.GREBE_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.LITTLE_GREBE.get()), EntityClassification.CREATURE, 2, 3);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.LIZARD_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.LIZARD.get()), EntityClassification.CREATURE, 1, 4);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.CINDERSHELL_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.CINDERSHELL.get()), EntityClassification.MONSTER, 1, 2);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.FRIENDLY_SPORELING_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.FRIENDLY_SPORELING.get()), EntityClassification.CREATURE, 3, 5);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.HOSTILE_SPORELING_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.HOSTILE_SPORELING.get()), EntityClassification.MONSTER, 2, 4);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.NEUTRAL_SPORELING_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.NEUTRAL_SPORELING.get()), EntityClassification.MONSTER, 2, 4);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.LILYTAD_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.LILYTAD.get()), EntityClassification.CREATURE, 1, 1);
        ModEntitySpawns.checkAndAddSpawn(event, biomeName, CNBConfig.ServerConfig.YETI_CONFIG, (EntityType<? extends Entity>)((EntityType)ModEntityTypes.YETI.get()), EntityClassification.CREATURE, 2, 3);
    }

    private static void checkAndAddSpawn(BiomeLoadingEvent event, String biomeName, EntityConfig config, EntityType<? extends Entity> type, EntityClassification classification, int min, int max) {
        if (config.spawnBiomes.contains(biomeName)) {
            MobSpawnInfo.Spawners spawnInfo = new MobSpawnInfo.Spawners(type, config.spawnRate, min, max);
            event.getSpawns().getSpawner(classification).add(spawnInfo);
        }
    }

    public static void entitySpawnPlacementRegistry() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.LITTLE_GREBE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GrebeEntity::canGrebeSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.LIZARD.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, LizardEntity::canLizardSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.CINDERSHELL.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CindershellEntity::canCindershellSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.HOSTILE_SPORELING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HostileSporelingEntity::canSporelingSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.NEUTRAL_SPORELING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NeutralSporelingEntity::canSporelingSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.FRIENDLY_SPORELING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FriendlySporelingEntity::canSporelingSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.LILYTAD.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, LilytadEntity::canLilytadSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.YETI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, YetiEntity::canYetiSpawn);
    }
}

