/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client.overlays;

import com.black_dog20.servertabinfo.Config;
import com.black_dog20.servertabinfo.client.ClientDataManager;
import com.black_dog20.servertabinfo.client.keybinds.Keybinds;
import com.black_dog20.servertabinfo.common.utils.Dimension;
import com.black_dog20.servertabinfo.common.utils.Translations;
import com.black_dog20.servertabinfo.repack.bml.client.DrawingContext;
import com.black_dog20.servertabinfo.repack.bml.client.overlay.Overlay;
import com.black_dog20.servertabinfo.repack.bml.client.rows.Row;
import com.black_dog20.servertabinfo.repack.bml.client.rows.RowHelper;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.BlankColumn;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.Column;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.HeadColumn;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.ITextComponentColumn;
import com.black_dog20.servertabinfo.repack.bml.utils.dimension.DimensionUtil;
import com.black_dog20.servertabinfo.repack.bml.utils.text.TextComponentBuilder;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@OnlyIn(value=Dist.CLIENT)
public class PlayerListOverlay
extends Overlay.Pre {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private Minecraft minecraft;
    private FontRenderer fontRenderer;
    private ItemRenderer itemRenderer;
    private long lastRenderTime = Util.func_211177_b();
    private int ticks = 0;
    private int page = 1;

    public PlayerListOverlay() {
        this.minecraft = Minecraft.func_71410_x();
        this.fontRenderer = this.minecraft.field_71466_p;
        this.itemRenderer = this.minecraft.func_175599_af();
    }

    @Override
    public void onRender(MatrixStack matrixStack, int width, int height) {
        if (Keybinds.SHOW.func_151470_d()) {
            return;
        }
        int y = 10;
        boolean z = false;
        if (Util.func_211177_b() - 2000L > this.lastRenderTime) {
            this.page = 1;
            this.ticks = 1;
        }
        this.fontRenderer.getClass();
        int itemsPerPage = (int)Math.floor((height - 7 * y) / 9);
        List<Row> rows = this.getRows();
        int maxPages = (int)Math.ceil((double)rows.size() / (double)itemsPerPage);
        if (this.ticks % 300 == 0) {
            this.page = this.page >= maxPages ? 1 : ++this.page;
            this.ticks = 1;
        }
        rows = this.getPagedRows(rows, itemsPerPage);
        int maxWidth = RowHelper.getMaxWidth(rows);
        int x = width / 2 - maxWidth / 2;
        DrawingContext drawingContext = new DrawingContext(matrixStack, width, height, x, y, (float)z, this.fontRenderer, this.itemRenderer);
        y = RowHelper.drawRowsWithBackground(drawingContext, rows);
        this.fontRenderer.func_243246_a(matrixStack, Translations.PAGE.get(this.page, maxPages), (float)(width / 2 + 2), (float)(y + 2), -1);
        ++this.ticks;
        this.lastRenderTime = Util.func_211177_b();
    }

    @Override
    public boolean doRender(RenderGameOverlayEvent.ElementType elementType) {
        if (elementType == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            return (Boolean)Config.REPLACE_PLAYER_LIST.get();
        }
        return false;
    }

    @Override
    public boolean doesCancelEvent() {
        return true;
    }

    private List<Row> getRows() {
        ClientPlayNetHandler nethandlerplayclient = this.minecraft.field_71439_g.field_71174_a;
        List list = ENTRY_ORDERING.sortedCopy((Iterable)nethandlerplayclient.func_175106_d());
        return list.stream().map(this::buildRow).collect(Collectors.toCollection(LinkedList::new));
    }

    private Row buildRow(NetworkPlayerInfo playerInfo) {
        Row.RowBuilder builder = new Row.RowBuilder();
        Scoreboard scoreboard = Optional.ofNullable(this.minecraft.field_71441_e).map(ClientWorld::func_96441_U).orElse(null);
        return builder.withColumn(HeadColumn.of("head", playerInfo)).withColumn(ITextComponentColumn.of("name", this.getPlayerName(playerInfo))).withColumn(BlankColumn.of("nameSpace", 6)).withColumn(ITextComponentColumn.of("dim", this.getPlayerDim(playerInfo))).withColumn(BlankColumn.of("dimSpace", 3)).withColumn(ITextComponentColumn.of("score", this.getPlayerScore(playerInfo, scoreboard)), this.showScoreObjective(scoreboard)).withColumn(BlankColumn.of("scoreSpace", 3), this.showScoreObjective(scoreboard)).withColumn(ITextComponentColumn.of("ping", this.getPlayerPing(playerInfo), Column.Alignment.RIGHT)).withColumn(BlankColumn.of("pingSpace", 1)).build();
    }

    private ITextComponent getPlayerScore(NetworkPlayerInfo playerInfo, Scoreboard scoreboard) {
        ScoreObjective scoreObjective = Optional.ofNullable(scoreboard).map(s -> s.func_96539_a(0)).orElse(null);
        return TextComponentBuilder.of("").with(this.getScore(playerInfo, scoreboard, scoreObjective), this.showPlayerScore(playerInfo, scoreObjective)).format(TextFormatting.YELLOW).build();
    }

    private Supplier<Boolean> showPlayerScore(NetworkPlayerInfo playerInfo, ScoreObjective scoreObjective) {
        return () -> scoreObjective != null && GameType.SPECTATOR != playerInfo.func_178848_b();
    }

    private int getScore(NetworkPlayerInfo playerInfo, Scoreboard scoreboard, ScoreObjective scoreObjective) {
        if (scoreObjective != null) {
            Score score = scoreboard.func_96529_a(playerInfo.func_178845_a().getName(), scoreObjective);
            return score.func_96652_c();
        }
        return 0;
    }

    private Supplier<Boolean> showScoreObjective(Scoreboard scoreboard) {
        return () -> scoreboard != null && scoreboard.func_96539_a(0) != null;
    }

    private boolean isAllowed() {
        return (Boolean)Config.OP_ONLY_MODE.get() == false || this.minecraft.func_71356_B() || Optional.ofNullable(this.minecraft.field_71439_g).map(player -> player.func_211513_k(1)).orElse(false) != false;
    }

    private List<Row> getPagedRows(List<Row> rows, int itemsPerPage) {
        rows = rows.stream().skip((this.page - 1) * itemsPerPage).limit(itemsPerPage).collect(Collectors.toCollection(LinkedList::new));
        return rows;
    }

    private ITextComponent getPlayerName(NetworkPlayerInfo playerInfo) {
        return Optional.ofNullable(playerInfo).map(NetworkPlayerInfo::func_178854_k).orElseGet(() -> ScorePlayerTeam.func_237500_a_((Team)playerInfo.func_178850_i(), (ITextComponent)new StringTextComponent(playerInfo.func_178845_a().getName())));
    }

    private ITextComponent getPlayerPing(NetworkPlayerInfo playerInfo) {
        return TextComponentBuilder.of(playerInfo.func_178853_c()).with(Translations.MS).build();
    }

    private ITextComponent getPlayerDim(NetworkPlayerInfo playerInfo) {
        ResourceLocation dimName = ClientDataManager.PLAYER_DIMENSIONS.getOrDefault(playerInfo.func_178845_a().getId(), null);
        return TextComponentBuilder.of((ITextComponent)this.getDimensionName(dimName)).with((ITextComponent)this.getDimensionTps(dimName), this::isAllowed).build();
    }

    private TextComponent getDimensionName(ResourceLocation dimensionName) {
        if (dimensionName == null) {
            return (TextComponent)Translations.UNKOWN.get();
        }
        if (ClientDataManager.DIMENSION_NAME_CACHE.containsKey(dimensionName)) {
            return ClientDataManager.DIMENSION_NAME_CACHE.get(dimensionName);
        }
        TextComponent name = DimensionUtil.getFormattedDimensionName(dimensionName, "servertabinfo");
        ClientDataManager.DIMENSION_NAME_CACHE.put(dimensionName, name);
        return name;
    }

    private TextComponent getDimensionTps(ResourceLocation dimensionName) {
        if (dimensionName == null) {
            return new StringTextComponent("");
        }
        Dimension dimension = ClientDataManager.DIMENSIONS.stream().filter(d -> d.name.equals((Object)dimensionName)).findFirst().orElse(null);
        if (dimension == null) {
            return new StringTextComponent("");
        }
        int tps = dimension.tps;
        TextFormatting color = TextFormatting.GREEN;
        if (tps < 20) {
            color = TextFormatting.YELLOW;
        }
        if (tps <= 10) {
            color = TextFormatting.RED;
        }
        return TextComponentBuilder.of("(").with(tps).format(color).with(")").build();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo player1, NetworkPlayerInfo player2) {
            ScorePlayerTeam scoreplayerteam1 = player1.func_178850_i();
            ScorePlayerTeam scoreplayerteam2 = player2.func_178850_i();
            return ComparisonChain.start().compareTrueFirst(player1.func_178848_b() != GameType.SPECTATOR, player2.func_178848_b() != GameType.SPECTATOR).compare((Comparable)((Object)this.getName(scoreplayerteam1)), (Comparable)((Object)this.getName(scoreplayerteam2))).compare((Comparable)((Object)player1.func_178845_a().getName()), (Comparable)((Object)player2.func_178845_a().getName())).result();
        }

        private String getName(ScorePlayerTeam scorePlayerTeam) {
            return Optional.ofNullable(scorePlayerTeam).map(ScorePlayerTeam::func_96661_b).orElse("");
        }
    }
}

