/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.repack.bml.utils.color;

import com.black_dog20.servertabinfo.repack.bml.utils.math.MathUtil;
import java.awt.Color;

public class Color4i {
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private Color color;

    private Color4i(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.color = new Color(red, green, blue, alpha);
    }

    public static Color4i of(int red, int green, int blue, int alpha) {
        int r = MathUtil.clamp(red, 0, 255);
        int g = MathUtil.clamp(green, 0, 255);
        int b = MathUtil.clamp(blue, 0, 255);
        int a = MathUtil.clamp(alpha, 0, 255);
        return new Color4i(r, g, b, a);
    }

    public static Color4i of(int red, int green, int blue) {
        return Color4i.of(red, green, blue, 255);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(int alpha) {
        int a = MathUtil.clamp(alpha, 0, 255);
        return new Color(this.red, this.green, this.blue, a);
    }

    public int getValue() {
        return this.color.getRGB();
    }

    public int getValue(int alpha) {
        int a = MathUtil.clamp(alpha, 0, 255);
        return new Color(this.red, this.green, this.blue, a).getRGB();
    }
}

