/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import wile.engineerstools.items.EtItem;

public class SleepingBagItem
extends EtItem {
    private final boolean respawn_at_bed = false;

    public SleepingBagItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200915_b(4096).setNoRepair());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).isBed((IBlockReader)context.func_195991_k(), context.func_195995_a(), (LivingEntity)context.func_195999_j())) {
            return ActionResultType.PASS;
        }
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.CONSUME;
        }
        this.onUse(context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l());
        return ActionResultType.SUCCESS;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    private void onUse(PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (world.func_201670_d() || side != Direction.UP || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        if (!world.func_230315_m_().func_236043_f_()) {
            ITextComponent msg = PlayerEntity.SleepResult.NOT_POSSIBLE_HERE.func_221259_a();
            if (msg != null) {
                player.func_146105_b(msg, true);
            }
            return;
        }
        boolean setspawn = true;
        this.tryServerPlayerSleep((ServerPlayerEntity)player, world, pos.func_177984_a(), setspawn).ifLeft(sr -> {
            switch (sr) {
                case TOO_FAR_AWAY: {
                    break;
                }
                default: {
                    if (sr.func_221259_a() == null) break;
                    player.func_146105_b(sr.func_221259_a(), true);
                }
            }
        });
        if (!player.field_70170_p.func_72935_r()) {
            ((ServerWorld)player.field_70170_p).func_72854_c();
        }
    }

    private Either<PlayerEntity.SleepResult, Unit> tryServerPlayerSleep(ServerPlayerEntity player, World world, BlockPos at, boolean set_spawn_point) {
        if (!player.func_70089_S()) {
            return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
        if (!player.field_70170_p.func_230315_m_().func_236043_f_()) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
        }
        if (!player.func_184812_l_()) {
            double d0 = 8.0;
            double d1 = 5.0;
            if (!player.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)(at.func_177958_n() - 8), (double)(at.func_177956_o() - 5), (double)(at.func_177952_p() - 8), (double)(at.func_177958_n() + 8), (double)(at.func_177956_o() + 5), (double)(at.func_177952_p() + 8)), en -> en.func_230292_f_((PlayerEntity)player)).isEmpty()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
            }
        }
        if (set_spawn_point) {
            player.func_213369_d(at);
        }
        if (player.field_70170_p.func_72935_r()) {
            return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
        if (!player.func_70608_bn()) {
            Optional<BlockPos> optAt = Optional.of(at);
            PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, optAt);
            if (ret != null) {
                return Either.left((Object)ret);
            }
            player.func_213342_e(at);
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
    }

    public static void onSleepingLocationCheckEvent(SleepingLocationCheckEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SleepingBagItem)) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SleepingBagItem)) {
            return;
        }
        CompoundNBT nbt = player.getPersistentData();
        nbt.func_74768_a("ETCorrectBedLocation", 1);
    }
}

