/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.recipe.GlyphPressRecipe;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.VanillaPotionRecipe;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.spell.validation.StandardSpellValidator;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class ArsNouveauAPI {
    private HashMap<String, AbstractSpellPart> spell_map;
    private HashMap<String, AbstractRitual> ritualMap;
    private HashMap<String, Glyph> glyphMap;
    private HashMap<String, RitualTablet> ritualParchmentMap;
    private ISpellValidator craftingSpellValidator;
    private ISpellValidator castingSpellValidator;
    private List<IEnchantingRecipe> enchantingApparatusRecipes;
    private List<AbstractSpellPart> startingSpells;
    public List<VanillaPotionRecipe> vanillaPotionRecipes = new ArrayList<VanillaPotionRecipe>();
    private List<BrewingRecipe> brewingRecipes;
    private static final ArsNouveauAPI arsNouveauAPI = new ArsNouveauAPI();

    public List<AbstractSpellPart> getDefaultStartingSpells() {
        return this.spell_map.values().stream().filter(Config::isStarterEnabled).collect(Collectors.toList());
    }

    public boolean addStartingSpell(String tag) {
        if (ArsNouveauAPI.getInstance().getSpell_map().containsKey(tag)) {
            return this.startingSpells.add(ArsNouveauAPI.getInstance().getSpell_map().get(tag));
        }
        throw new IllegalStateException("Attempted to add a starting spell for an unregistered spell. Spells must be added to the Spell Map first!");
    }

    public Item getGlyphItem(String glyphName) {
        for (Item i : ItemsRegistry.RegistrationHandler.ITEMS) {
            if (!i.getRegistryName().equals((Object)new ResourceLocation("ars_nouveau", this.getSpellRegistryName(glyphName)))) continue;
            return i;
        }
        return null;
    }

    public Item getGlyphItem(AbstractSpellPart spell) {
        return this.getGlyphItem(spell.tag);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part) {
        this.glyphMap.put(id, new Glyph(this.getSpellRegistryName(id), part));
        return this.spell_map.put(id, part);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part, int manaCost) {
        Config.addonSpellCosts.put(id, manaCost);
        return this.registerSpell(id, part);
    }

    public AbstractRitual registerRitual(String id, AbstractRitual ritual) {
        this.ritualParchmentMap.put(id, new RitualTablet(this.getRitualRegistryName(id), ritual));
        return this.ritualMap.put(id, ritual);
    }

    @Nullable
    public AbstractRitual getRitual(String id) {
        if (!this.ritualMap.containsKey(id)) {
            return null;
        }
        try {
            return (AbstractRitual)this.ritualMap.get(id).getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public AbstractRitual getRitual(String id, RitualTile tile, RitualContext context) {
        AbstractRitual ritual = this.getRitual(id);
        if (ritual != null) {
            ritual.tile = tile;
            ritual.setContext(context);
        }
        return ritual;
    }

    public String getSpellRegistryName(String id) {
        return "glyph_" + id.toLowerCase();
    }

    public String getRitualRegistryName(String id) {
        return "ritual_" + id.toLowerCase();
    }

    public Map<String, AbstractSpellPart> getSpell_map() {
        return this.spell_map;
    }

    public Map<String, Glyph> getGlyphMap() {
        return this.glyphMap;
    }

    public Map<String, AbstractRitual> getRitualMap() {
        return this.ritualMap;
    }

    public Map<String, RitualTablet> getRitualItemMap() {
        return this.ritualParchmentMap;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes() {
        return this.enchantingApparatusRecipes;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes(World world) {
        ArrayList<IEnchantingRecipe> recipes = new ArrayList<IEnchantingRecipe>(this.enchantingApparatusRecipes);
        RecipeManager manager = world.func_199532_z();
        for (IRecipe i : manager.func_199510_b()) {
            if (!(i instanceof EnchantingApparatusRecipe)) continue;
            EnchantingApparatusRecipe recipe = (EnchantingApparatusRecipe)i;
            recipes.add((IEnchantingRecipe)i);
        }
        return recipes;
    }

    public GlyphPressRecipe getGlyphPressRecipe(World world, Item reagent, @Nullable ISpellTier.Tier tier) {
        if (reagent == null || reagent == Items.field_190931_a) {
            return null;
        }
        RecipeManager manager = world.func_199532_z();
        for (IRecipe i : manager.func_199510_b()) {
            if (!(i instanceof GlyphPressRecipe) || ((GlyphPressRecipe)i).reagent.func_77973_b() != reagent || ((GlyphPressRecipe)i).tier != tier) continue;
            return (GlyphPressRecipe)i;
        }
        return null;
    }

    public List<BrewingRecipe> getAllPotionRecipes() {
        if (this.brewingRecipes == null) {
            this.brewingRecipes = new ArrayList<BrewingRecipe>();
            BrewingRecipeRegistry.getRecipes().forEach(ib -> {
                if (ib instanceof BrewingRecipe) {
                    this.brewingRecipes.add((BrewingRecipe)ib);
                }
            });
            this.vanillaPotionRecipes.forEach(vanillaPotionRecipe -> {
                BrewingRecipe recipe = new BrewingRecipe((Ingredient)PotionIngredient.fromPotion(vanillaPotionRecipe.potionIn), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{vanillaPotionRecipe.reagent}), PotionIngredient.fromPotion(vanillaPotionRecipe.potionOut).getStack());
                this.brewingRecipes.add(recipe);
            });
        }
        return this.brewingRecipes;
    }

    public ISpellValidator getSpellCraftingSpellValidator() {
        return this.craftingSpellValidator;
    }

    public ISpellValidator getSpellCastingSpellValidator() {
        return this.castingSpellValidator;
    }

    private ArsNouveauAPI() {
        this.spell_map = new HashMap();
        this.glyphMap = new HashMap();
        this.startingSpells = new ArrayList<AbstractSpellPart>();
        this.enchantingApparatusRecipes = new ArrayList<IEnchantingRecipe>();
        this.ritualMap = new HashMap();
        this.ritualParchmentMap = new HashMap();
        this.craftingSpellValidator = new StandardSpellValidator(false);
        this.castingSpellValidator = new StandardSpellValidator(true);
    }

    public static ArsNouveauAPI getInstance() {
        return arsNouveauAPI;
    }

    public static enum PatchouliCategories {
        spells,
        machines,
        equipment,
        resources,
        getting_started,
        automation;

    }
}

