/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DelayedSpellEvent
implements ITimedEvent {
    private int duration;
    private final List<AbstractSpellPart> recipe;
    private final RayTraceResult result;
    private final World world;
    private final LivingEntity shooter;

    public DelayedSpellEvent(int delay, List<AbstractSpellPart> recipe, RayTraceResult result, World world, LivingEntity shooter) {
        this.duration = delay;
        this.recipe = recipe;
        this.result = result;
        this.world = world;
        this.shooter = shooter;
    }

    @Override
    public void tick() {
        --this.duration;
        if (this.duration <= 0) {
            this.resolveSpell();
        }
    }

    public void resolveSpell() {
        if (this.world == null) {
            return;
        }
        SpellContext context = new SpellContext(this.recipe, this.shooter);
        SpellResolver.resolveEffects(this.world, this.shooter, this.result, new Spell(this.recipe), context);
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0 || this.world == null;
    }
}

