/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface ICasterTool
extends IScribeable,
IDisplayMana {
    @Override
    default public boolean onScribe(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        ItemStack heldStack = player.func_184586_b(handIn);
        ISpellCaster caster = this.getSpellCaster(stack);
        if (caster == null) {
            return false;
        }
        if (!(heldStack.func_77973_b() instanceof SpellBook) && !(heldStack.func_77973_b() instanceof SpellParchment) || heldStack.func_77978_p() == null) {
            return false;
        }
        boolean success = false;
        Spell spell = new Spell();
        if (heldStack.func_77973_b() instanceof SpellBook) {
            spell = SpellBook.getRecipeFromTag(heldStack.func_77978_p(), SpellBook.getMode(heldStack.func_77978_p()));
            caster.setColor(SpellBook.getSpellColor(heldStack.func_77978_p(), SpellBook.getMode(heldStack.func_77978_p())));
        } else if (heldStack.func_77973_b() instanceof SpellParchment) {
            spell = new Spell(SpellParchment.getSpellRecipe(heldStack));
        }
        if (this.isScribedSpellValid(caster, player, handIn, stack, spell)) {
            success = this.setSpell(caster, player, handIn, stack, spell);
            if (success) {
                this.sendSetMessage(player);
                return success;
            }
        } else {
            this.sendInvalidMessage(player);
        }
        return success;
    }

    default public void sendSetMessage(PlayerEntity player) {
        PortUtil.sendMessageNoSpam((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.set_spell"));
    }

    default public void sendInvalidMessage(PlayerEntity player) {
        PortUtil.sendMessageNoSpam((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.invalid_spell"));
    }

    @Nonnull
    default public ISpellCaster getSpellCaster(ItemStack stack) {
        return SpellCaster.deserialize(stack);
    }

    default public boolean setSpell(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        caster.setSpell(spell);
        return true;
    }

    default public boolean isScribedSpellValid(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        return spell.isValid();
    }

    @Override
    default public boolean shouldDisplay(ItemStack stack) {
        return true;
    }

    default public void getInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        ISpellCaster caster = this.getSpellCaster(stack);
        if (caster.getSpell() == null || caster.getSpell().isEmpty()) {
            tooltip2.add((ITextComponent)new TranslationTextComponent("ars_nouveau.tooltip.can_inscribe"));
            return;
        }
        Spell spell = caster.getSpell();
        tooltip2.add((ITextComponent)new StringTextComponent(spell.getDisplayString()));
        if (!caster.getFlavorText().isEmpty()) {
            tooltip2.add((ITextComponent)new StringTextComponent(caster.getFlavorText()).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.BLUE)));
        }
    }
}

