/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.loot;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.datagen.DungeonLootGenerator;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExplosion;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLight;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodRune;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class LootTables {
    public static List<Supplier<ItemStack>> BASIC_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static List<Supplier<ItemStack>> UNCOMMON_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static List<Supplier<ItemStack>> RARE_LOOT = new ArrayList<Supplier<ItemStack>>();
    public static Random r = new Random();

    public static ItemStack getRandomItem(List<Supplier<ItemStack>> pool) {
        return pool.isEmpty() ? ItemStack.field_190927_a : pool.get(r.nextInt(pool.size())).get();
    }

    public static List<ItemStack> getRandomRoll(DungeonLootGenerator.DungeonLootEnhancerModifier modifier) {
        int i;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (i = 0; i < 4; ++i) {
            if (!(r.nextDouble() <= modifier.commonChance)) continue;
            stacks.add(LootTables.getRandomItem(BASIC_LOOT));
        }
        for (i = 0; i < 3; ++i) {
            if (!(r.nextDouble() <= modifier.uncommonChance)) continue;
            stacks.add(LootTables.getRandomItem(UNCOMMON_LOOT));
        }
        for (i = 0; i < 2; ++i) {
            if (!(r.nextDouble() <= modifier.rareChance)) continue;
            stacks.add(LootTables.getRandomItem(RARE_LOOT));
        }
        return stacks;
    }

    public static ItemStack makeTome(String name, Spell spell) {
        ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.CASTER_TOME);
        SpellCaster spellCaster = SpellCaster.deserialize(stack);
        spellCaster.setSpell(spell);
        stack.func_200302_a((ITextComponent)new StringTextComponent(name).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_PURPLE).func_240722_b_(Boolean.valueOf(true))));
        return stack;
    }

    public static ItemStack makeTome(String name, Spell spell, String flavorText) {
        ItemStack stack = LootTables.makeTome(name, spell);
        SpellCaster spellCaster = SpellCaster.deserialize(stack);
        spellCaster.setFlavorText(flavorText);
        return stack;
    }

    static {
        BASIC_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.manaGem, 1 + r.nextInt(5)));
        BASIC_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.WILDEN_HORN, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.WILDEN_SPIKE, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.WILDEN_WING, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> new ItemStack((IItemProvider)BlockRegistry.MANA_BERRY_BUSH, 1 + r.nextInt(3)));
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)stack, (Potion)ModPotions.LONG_MANA_REGEN_POTION);
            return stack;
        });
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)stack, (Potion)ModPotions.STRONG_MANA_REGEN_POTION);
            return stack;
        });
        BASIC_LOOT.add(() -> {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)stack, (Potion)ModPotions.MANA_REGEN_POTION);
            return stack;
        });
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.warpScroll, 1 + r.nextInt(2)));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.carbuncleShard));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.sylphShard));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.WIXIE_SHARD));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.AMPLIFY_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.SPLIT_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> new ItemStack((IItemProvider)ItemsRegistry.PIERCE_ARROW, 16 + r.nextInt(16)));
        UNCOMMON_LOOT.add(() -> {
            ArrayList<RitualTablet> tablets = new ArrayList<RitualTablet>(ArsNouveauAPI.getInstance().getRitualItemMap().values());
            return new ItemStack((IItemProvider)tablets.get(r.nextInt(tablets.size())));
        });
        RARE_LOOT.add(() -> LootTables.makeTome("Xacris' Tiny Hut", new Spell().add(MethodUnderfoot.INSTANCE).add(EffectPhantomBlock.INSTANCE).add(AugmentAOE.INSTANCE, 3).add(AugmentPierce.INSTANCE, 3), "Builds a small hut around the user."));
        RARE_LOOT.add(() -> LootTables.makeTome("Glow Trap", new Spell().add(MethodRune.INSTANCE).add(EffectSnare.INSTANCE).add(AugmentExtendTime.INSTANCE).add(EffectLight.INSTANCE), "Snares the target and grants other targets Glowing."));
        RARE_LOOT.add(() -> LootTables.makeTome("Bailey's Bovine Rocket", new Spell().add(MethodProjectile.INSTANCE).add(EffectLaunch.INSTANCE).add(AugmentAmplify.INSTANCE, 2).add(EffectDelay.INSTANCE).add(EffectExplosion.INSTANCE).add(AugmentAmplify.INSTANCE)));
        RARE_LOOT.add(() -> LootTables.makeTome("Arachne's Weaving", new Spell().add(MethodProjectile.INSTANCE).add(AugmentSplit.INSTANCE, 2).add(EffectSnare.INSTANCE).add(AugmentExtendTime.INSTANCE).add(AugmentExtendTime.INSTANCE), "Creates three snaring projectiles."));
        RARE_LOOT.add(() -> LootTables.makeTome("Warp Impact", new Spell().add(MethodProjectile.INSTANCE).add(EffectBlink.INSTANCE).add(EffectExplosion.INSTANCE).add(AugmentAOE.INSTANCE), "Teleportation, with style!"));
        RARE_LOOT.add(() -> LootTables.makeTome("Farfalla's Frosty Flames", new Spell().add(MethodProjectile.INSTANCE).add(EffectIgnite.INSTANCE).add(EffectDelay.INSTANCE).add(EffectConjureWater.INSTANCE).add(EffectFreeze.INSTANCE), "Creates a fire that quickly freezes to ice."));
        RARE_LOOT.add(() -> LootTables.makeTome("Gootastic's Telekinetic Fishing Rod", new Spell().add(MethodProjectile.INSTANCE).add(EffectLaunch.INSTANCE).add(AugmentAmplify.INSTANCE, 2).add(EffectDelay.INSTANCE).add(EffectPull.INSTANCE).add(AugmentAmplify.INSTANCE, 2), "The squid's Lovecraftian roots appear to make it immune."));
        RARE_LOOT.add(() -> LootTables.makeTome("Potent Toxin", new Spell().add(MethodProjectile.INSTANCE).add(EffectHex.INSTANCE).add(EffectHarm.INSTANCE).add(AugmentExtendTime.INSTANCE), "Poisons that target and causes them to take additional damage from all sources."));
        RARE_LOOT.add(() -> LootTables.makeTome("The Shadow's Temporary Tunnel", new Spell().add(MethodTouch.INSTANCE).add(EffectIntangible.INSTANCE).add(AugmentAOE.INSTANCE, 2).add(AugmentPierce.INSTANCE, 5).add(AugmentExtendTime.INSTANCE), "Creates a temporary tunnel of blocks."));
        RARE_LOOT.add(() -> LootTables.makeTome("Vault", new Spell().add(MethodSelf.INSTANCE).add(EffectLaunch.INSTANCE).add(EffectDelay.INSTANCE).add(EffectLeap.INSTANCE).add(EffectSlowfall.INSTANCE), "Sometimes you just need to get over that wall."));
        RARE_LOOT.add(() -> LootTables.makeTome("Fireball!", new Spell().add(MethodProjectile.INSTANCE).add(EffectIgnite.INSTANCE).add(EffectExplosion.INSTANCE).add(AugmentAmplify.INSTANCE, 2).add(AugmentAOE.INSTANCE, 2), "A classic."));
        RARE_LOOT.add(() -> LootTables.makeTome("Rune of Renewing", new Spell().add(MethodRune.INSTANCE).add(EffectDispel.INSTANCE).add(EffectHeal.INSTANCE).add(AugmentExtendTime.INSTANCE), "Cures status effects and grants regeneration."));
    }
}

