/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.util.SpellPartConfigUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractSpellPart
implements ISpellTier,
Comparable<AbstractSpellPart> {
    public String tag;
    public String name;
    public ForgeConfigSpec CONFIG;
    public ForgeConfigSpec.IntValue COST;
    public ForgeConfigSpec.BooleanValue ENABLED;
    public ForgeConfigSpec.BooleanValue STARTER_SPELL;
    public ForgeConfigSpec.IntValue PER_SPELL_LIMIT;
    private SpellPartConfigUtil.AugmentLimits augmentLimits;

    public abstract int getManaCost();

    public String getTag() {
        return this.tag;
    }

    public String getIcon() {
        return this.tag + ".png";
    }

    protected AbstractSpellPart(String tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    public int getAdjustedManaCost(List<AbstractAugment> augmentTypes) {
        int cost = this.getConfigCost();
        for (AbstractAugment a : augmentTypes) {
            if (a instanceof AugmentDampen && !this.dampenIsAllowed()) continue;
            cost += a.getConfigCost();
        }
        return Math.max(cost, 0);
    }

    public int getConfigCost() {
        return this.COST == null ? this.getManaCost() : ((Integer)this.COST.get()).intValue();
    }

    @Nullable
    public Item getCraftingReagent() {
        return null;
    }

    public boolean dampenIsAllowed() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    public static int getBuffCount(List<AbstractAugment> augments, Class<? extends AbstractSpellPart> spellClass) {
        return (int)augments.stream().filter(spellClass::isInstance).count();
    }

    public boolean hasBuff(List<AbstractAugment> augments, Class spellClass) {
        return AbstractSpellPart.getBuffCount(augments, spellClass) > 0;
    }

    public int getAmplificationBonus(List<AbstractAugment> augmentTypes) {
        return AbstractSpellPart.getBuffCount(augmentTypes, AugmentAmplify.class) - AbstractSpellPart.getBuffCount(augmentTypes, AugmentDampen.class);
    }

    @Nonnull
    public abstract Set<AbstractAugment> getCompatibleAugments();

    protected Set<AbstractAugment> augmentSetOf(AbstractAugment ... augments) {
        return Collections.unmodifiableSet(new HashSet<AbstractAugment>(Arrays.asList(augments)));
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getTier().ordinal() - o.getTier().ordinal();
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.getName());
        jsonobject.addProperty("icon", "ars_nouveau:" + this.getItemID());
        jsonobject.addProperty("category", "spells_" + (this.getTier().ordinal() + 1));
        jsonobject.addProperty("sortnum", (Number)(this instanceof AbstractCastMethod ? 1 : (this instanceof AbstractEffect ? 2 : 3)));
        JsonArray jsonArray = new JsonArray();
        JsonObject descPage = new JsonObject();
        descPage.addProperty("type", "text");
        descPage.addProperty("text", "ars_nouveau.glyph_desc." + this.tag);
        JsonObject infoPage = new JsonObject();
        infoPage.addProperty("type", "glyph_recipe");
        infoPage.addProperty("recipe", "ars_nouveau:glyph_" + this.tag);
        infoPage.addProperty("tier", this.getTier().name());
        String manaCost = this.getManaCost() < 20 ? "Low" : "Medium";
        manaCost = this.getManaCost() > 50 ? "High" : manaCost;
        infoPage.addProperty("mana_cost", manaCost);
        if (this.getCraftingReagent() != null) {
            String clayType = this.getTier() == ISpellTier.Tier.ONE ? ItemsRegistry.magicClay.getRegistryName().toString() : (this.getTier() == ISpellTier.Tier.TWO ? ItemsRegistry.marvelousClay.getRegistryName().toString() : ItemsRegistry.mythicalClay.getRegistryName().toString());
            infoPage.addProperty("clay_type", clayType);
            infoPage.addProperty("reagent", this.getCraftingReagent().getRegistryName().toString());
        }
        jsonArray.add((JsonElement)descPage);
        jsonArray.add((JsonElement)infoPage);
        jsonobject.add("pages", (JsonElement)jsonArray);
        return jsonobject;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("general");
        this.ENABLED = builder.comment("Is Enabled?").define("enabled", true);
        this.COST = builder.comment("Cost").defineInRange("cost", this.getManaCost(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.STARTER_SPELL = builder.comment("Is Starter Glyph?").define("starter", this.defaultedStarterGlyph());
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
    }

    public int getAugmentLimit(String augmentTag) {
        if (this.augmentLimits == null) {
            return Integer.MAX_VALUE;
        }
        return this.augmentLimits.getAugmentLimit(augmentTag);
    }

    protected void buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<String, Integer> defaults) {
        this.augmentLimits = SpellPartConfigUtil.buildAugmentLimitsConfig(builder, defaults);
    }

    protected Map<String, Integer> getDefaultAugmentLimits() {
        return new HashMap<String, Integer>();
    }

    public boolean defaultedStarterGlyph() {
        return false;
    }

    public String getItemID() {
        return "glyph_" + this.getTag();
    }

    public String getBookDescription() {
        return "";
    }

    public String getLocalizationKey() {
        return "ars_nouveau.glyph_name." + this.tag;
    }

    public String getLocaleName() {
        return new TranslationTextComponent(this.getLocalizationKey()).getString();
    }
}

