/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;

public class Spell {
    public static final Spell EMPTY = new Spell();
    public List<AbstractSpellPart> recipe;
    private int cost;

    public Spell(List<AbstractSpellPart> recipe) {
        this.recipe = recipe == null ? new ArrayList() : recipe;
        this.cost = this.getInitialCost();
    }

    public Spell() {
        this.recipe = new ArrayList<AbstractSpellPart>();
        this.cost = 0;
    }

    public Spell add(AbstractSpellPart spellPart) {
        this.recipe.add(spellPart);
        return this;
    }

    public Spell add(AbstractSpellPart spellPart, int count) {
        for (int i = 0; i < count; ++i) {
            this.recipe.add(spellPart);
        }
        return this;
    }

    public int getSpellSize() {
        return this.recipe.size();
    }

    @Nullable
    public AbstractCastMethod getCastMethod() {
        if (this.recipe == null || this.recipe.isEmpty()) {
            return null;
        }
        return this.recipe.get(0) instanceof AbstractCastMethod ? (AbstractCastMethod)this.recipe.get(0) : null;
    }

    public List<AbstractAugment> getAugments(int startPosition, @Nullable LivingEntity caster) {
        AbstractSpellPart next_spell;
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        if (this.recipe == null || this.recipe.isEmpty()) {
            return augments;
        }
        for (int j = startPosition + 1; j < this.recipe.size() && (next_spell = this.recipe.get(j)) instanceof AbstractAugment; ++j) {
            augments.add((AbstractAugment)next_spell);
        }
        if (caster != null) {
            augments.addAll(SpellRecipeUtil.getEquippedAugments(caster));
        }
        return augments;
    }

    public int getBuffsAtIndex(int startPosition, @Nullable LivingEntity caster, Class<? extends AbstractAugment> augmentClass) {
        return (int)this.getAugments(startPosition, caster).stream().filter(a -> a.getClass().equals(augmentClass)).count();
    }

    private int getInitialCost() {
        int cost = 0;
        if (this.recipe == null) {
            return cost;
        }
        for (int i = 0; i < this.recipe.size(); ++i) {
            AbstractSpellPart spell = this.recipe.get(i);
            if (spell instanceof AbstractAugment) continue;
            List<AbstractAugment> augments = this.getAugments(i, null);
            cost += spell.getAdjustedManaCost(augments);
        }
        return cost;
    }

    public int getCastingCost() {
        return Math.max(0, this.cost);
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public boolean isEmpty() {
        return this.recipe == null || this.recipe.isEmpty();
    }

    public String serialize() {
        ArrayList<String> tags = new ArrayList<String>();
        for (AbstractSpellPart slot : this.recipe) {
            tags.add(slot.tag);
        }
        return ((Object)tags).toString();
    }

    public static Spell deserialize(String recipeStr) {
        String[] recipeList;
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        if (recipeStr.length() <= 3) {
            return new Spell(recipe);
        }
        for (String id : recipeList = recipeStr.substring(1, recipeStr.length() - 1).split(",")) {
            if (!ArsNouveauAPI.getInstance().getSpell_map().containsKey(id.trim())) continue;
            recipe.add(ArsNouveauAPI.getInstance().getSpell_map().get(id.trim()));
        }
        return new Spell(recipe);
    }

    public String getDisplayString() {
        StringBuilder str = new StringBuilder();
        String lastStr = "";
        for (int i = 0; i < this.recipe.size(); ++i) {
            AbstractSpellPart spellPart = this.recipe.get(i);
            int num = 1;
            for (int j = i + 1; j < this.recipe.size() && spellPart.name.equals(this.recipe.get((int)j).name); ++j) {
                ++num;
            }
            if (num > 1) {
                str.append(spellPart.getLocaleName()).append(" x").append(num);
                i += num - 1;
            } else {
                str.append(spellPart.getLocaleName());
            }
            if (i >= this.recipe.size() - 1) continue;
            str.append(" -> ");
        }
        return str.toString();
    }

    public boolean isValid() {
        return this.recipe != null && !this.recipe.isEmpty();
    }
}

