/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntity;

public class SpellContext {
    private int manaCost;
    private boolean isCanceled;
    private final Spell spell;
    @Nullable
    public final LivingEntity caster;
    private int currentIndex;
    @Nullable
    public TileEntity castingTile;
    public ParticleColor.IntWrapper colors;
    private CasterType type;

    @Deprecated
    public SpellContext(List<AbstractSpellPart> spell, @Nullable LivingEntity caster) {
        this(new Spell(spell), caster);
    }

    public SpellContext(Spell spell, @Nullable LivingEntity caster) {
        this.spell = spell;
        this.caster = caster;
        this.isCanceled = false;
        this.currentIndex = 0;
        this.colors = ParticleUtil.defaultParticleColorWrapper();
    }

    public AbstractSpellPart nextSpell() {
        ++this.currentIndex;
        return this.getSpell().recipe.get(this.currentIndex - 1);
    }

    public void resetSpells() {
        this.currentIndex = 0;
    }

    public SpellContext withCastingTile(TileEntity tile) {
        this.castingTile = tile;
        return this;
    }

    public SpellContext withColors(ParticleColor.IntWrapper colors) {
        this.colors = colors;
        return this;
    }

    public SpellContext withType(CasterType type) {
        this.type = type;
        return this;
    }

    public CasterType getType() {
        return this.type == null ? CasterType.OTHER : this.type;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public void setManaCost(int manaCost) {
        this.manaCost = manaCost;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    public Spell getSpell() {
        return this.spell == null ? Spell.EMPTY : this.spell;
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.caster;
    }

    public static enum CasterType {
        ENTITY,
        RUNE,
        TURRET,
        OTHER;

    }
}

