/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class SpellResolver {
    public AbstractCastMethod castType;
    public Spell spell;
    public final SpellContext spellContext;
    public boolean silent;
    private final ISpellValidator spellValidator;

    @Deprecated
    public SpellResolver(AbstractCastMethod cast, List<AbstractSpellPart> spell, SpellContext context) {
        this.castType = cast;
        this.spell = new Spell(spell);
        this.spellContext = context;
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        this.spellValidator = api.getSpellCastingSpellValidator();
    }

    public SpellResolver(SpellContext spellContext) {
        this.spell = spellContext.getSpell();
        this.castType = spellContext.getSpell().getCastMethod();
        this.spellContext = spellContext;
        this.spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
    }

    @Deprecated
    public SpellResolver(AbstractSpellPart[] spellParts, SpellContext context) {
        this(new ArrayList<AbstractSpellPart>(Arrays.asList(spellParts)), context);
    }

    public SpellResolver withSilent(boolean isSilent) {
        this.silent = isSilent;
        return this;
    }

    @Deprecated
    public SpellResolver(List<AbstractSpellPart> spell, SpellContext context) {
        this(null, spell, context);
        AbstractCastMethod method = null;
        if (spell != null && !spell.isEmpty() && spell.get(0) instanceof AbstractCastMethod) {
            method = (AbstractCastMethod)spell.get(0);
        }
        this.castType = method;
    }

    @Deprecated
    public SpellResolver(List<AbstractSpellPart> spell, boolean silent, SpellContext context) {
        this(spell, context);
        this.silent = silent;
    }

    public boolean canCast(LivingEntity entity) {
        List<SpellValidationError> validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && !entity.func_130014_f_().field_72995_K) {
            PortUtil.sendMessageNoSpam((Entity)entity, (ITextComponent)validationErrors.get(0).makeTextComponentExisting());
        }
        return false;
    }

    boolean enoughMana(LivingEntity entity) {
        int totalCost = this.getCastingCost(this.spell, entity);
        AtomicBoolean canCast = new AtomicBoolean(false);
        ManaCapability.getMana(entity).ifPresent(mana -> {
            canCast.set((double)totalCost <= mana.getCurrentMana() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_());
            if (!(canCast.get() || entity.func_130014_f_().field_72995_K || this.silent)) {
                PortUtil.sendMessageNoSpam((Entity)entity, (ITextComponent)new TranslationTextComponent("ars_nouveau.spell.no_mana"));
            }
        });
        return canCast.get();
    }

    public boolean postEvent(LivingEntity entity) {
        return SpellUtil.postEvent(new SpellCastEvent(entity, this.spell));
    }

    public void onCast(ItemStack stack, LivingEntity livingEntity, World world) {
        if (this.canCast(livingEntity) && !this.postEvent(livingEntity)) {
            this.castType.onCast(stack, livingEntity, world, this.spell.getAugments(0, livingEntity), this.spellContext, this);
        }
    }

    public void onCastOnBlock(BlockRayTraceResult blockRayTraceResult, LivingEntity caster) {
        if (this.canCast(caster) && !this.postEvent(caster)) {
            this.castType.onCastOnBlock(blockRayTraceResult, caster, this.spell.getAugments(0, caster), this.spellContext, this);
        }
    }

    public void onCastOnBlock(ItemUseContext context) {
        if (this.canCast((LivingEntity)context.func_195999_j()) && !this.postEvent((LivingEntity)context.func_195999_j())) {
            this.castType.onCastOnBlock(context, this.spell.getAugments(0, (LivingEntity)context.func_195999_j()), this.spellContext, this);
        }
    }

    public void onCastOnEntity(ItemStack stack, LivingEntity playerIn, LivingEntity target, Hand hand) {
        if (this.canCast(playerIn) && !this.postEvent(playerIn)) {
            this.castType.onCastOnEntity(stack, playerIn, target, hand, this.spell.getAugments(0, playerIn), this.spellContext, this);
        }
    }

    public void onResolveEffect(World world, LivingEntity shooter, RayTraceResult result) {
        SpellResolver.resolveEffects(world, shooter, result, this.spell, this.spellContext);
    }

    public static void resolveEffects(World world, LivingEntity shooter, RayTraceResult result, Spell spell, SpellContext spellContext) {
        spellContext.resetSpells();
        shooter = SpellResolver.getUnwrappedCaster(world, shooter, spellContext);
        for (int i = 0; i < spell.recipe.size() && !spellContext.isCanceled(); ++i) {
            AbstractSpellPart part = spellContext.nextSpell();
            if (!(part instanceof AbstractEffect)) continue;
            ((AbstractEffect)part).onResolve(result, world, shooter, spell.getAugments(i, shooter), spellContext);
        }
    }

    public static LivingEntity getUnwrappedCaster(World world, LivingEntity shooter, SpellContext spellContext) {
        if (shooter == null && spellContext.castingTile != null) {
            shooter = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
            BlockPos pos = spellContext.castingTile.func_174877_v();
            shooter.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        shooter = shooter == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)) : shooter;
        return shooter;
    }

    public boolean wouldAllEffectsDoWork(RayTraceResult result, World world, LivingEntity entity, List<AbstractAugment> augments) {
        for (AbstractSpellPart spellPart : this.spell.recipe) {
            if (!(spellPart instanceof AbstractEffect) || ((AbstractEffect)spellPart).wouldSucceed(result, world, entity, augments)) continue;
            return false;
        }
        return true;
    }

    public boolean wouldCastSuccessfully(@Nullable ItemStack stack, LivingEntity caster, World world, List<AbstractAugment> augments) {
        return this.castType.wouldCastSuccessfully(stack, caster, world, augments, this);
    }

    public boolean wouldCastOnBlockSuccessfully(ItemUseContext context, List<AbstractAugment> augments) {
        return this.castType.wouldCastOnBlockSuccessfully(context, augments, this);
    }

    public boolean wouldCastOnBlockSuccessfully(BlockRayTraceResult blockRayTraceResult, LivingEntity caster) {
        return this.castType.wouldCastOnBlockSuccessfully(blockRayTraceResult, caster, this.spell.getAugments(0, caster), this);
    }

    public boolean wouldCastOnEntitySuccessfully(@Nullable ItemStack stack, LivingEntity caster, LivingEntity target, Hand hand, List<AbstractAugment> augments) {
        return this.castType.wouldCastOnEntitySuccessfully(stack, caster, target, hand, augments, this);
    }

    public void expendMana(LivingEntity entity) {
        int totalCost = this.getCastingCost(this.spell, entity);
        ManaCapability.getMana(entity).ifPresent(mana -> mana.removeMana(totalCost));
    }

    public int getCastingCost(Spell spell, LivingEntity e) {
        int cost = spell.getCastingCost() - ManaUtil.getPlayerDiscounts(e);
        return Math.max(cost, 0);
    }
}

