/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IMana;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.armor.MagicArmor;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ManaUtil {
    public static int getPlayerDiscounts(LivingEntity e) {
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                discounts.addAndGet(((IManaEquipment)item).getManaDiscount());
            }
        });
        return discounts.get();
    }

    public static int getMaxMana(PlayerEntity e) {
        IMana mana = (IMana)ManaCapability.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0;
        }
        int max = (Integer)Config.INIT_MAX_MANA.get();
        for (ItemStack i : e.func_184209_aF()) {
            if (i.func_77973_b() instanceof IManaEquipment) {
                max += ((IManaEquipment)i.func_77973_b()).getMaxManaBoost();
            }
            max += (Integer)Config.MANA_BOOST_BONUS.get() * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, (ItemStack)i);
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                max += ((IManaEquipment)item).getMaxManaBoost();
            }
        }
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus() > 5 ? mana.getGlyphBonus() - 5 : 0;
        max += numGlyphs * (Integer)Config.GLYPH_MAX_BONUS.get();
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max += tier * (Integer)Config.TIER_MAX_BONUS.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        return max;
    }

    public static double getManaRegen(PlayerEntity e) {
        IMana mana = (IMana)ManaCapability.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = ((Integer)Config.INIT_MANA_REGEN.get()).intValue();
        for (ItemStack i : e.func_184209_aF()) {
            if (i.func_77973_b() instanceof MagicArmor) {
                MagicArmor armor = (MagicArmor)i.func_77973_b();
                regen += (double)armor.getManaRegenBonus();
            }
            regen += (double)((Integer)Config.MANA_REGEN_ENCHANT_BONUS.get() * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, (ItemStack)i));
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                regen += (double)((IManaEquipment)item).getManaRegenBonus();
            }
        }
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus() > 5 ? (double)(mana.getGlyphBonus() - 5) : 0.0;
        regen += numGlyphs * (Double)Config.GLYPH_REGEN_BONUS.get();
        regen += (double)tier;
        if (e.func_70660_b((Effect)ModPotions.MANA_REGEN_EFFECT) != null) {
            regen += (double)((Integer)Config.MANA_REGEN_POTION.get() * (1 + e.func_70660_b((Effect)ModPotions.MANA_REGEN_EFFECT).func_76458_c()));
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }

    @Nullable
    public static BlockPos takeManaNearby(BlockPos pos, World world, int range, int mana) {
        BlockPos[] pos1 = new BlockPos[]{null};
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, 2, range), (BlockPos)pos.func_177982_a(-range, -2, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (pos1[0] == null && world.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(blockPos)).getCurrentMana() >= mana) {
                ((ManaJarTile)world.func_175625_s(blockPos)).removeMana(mana);
                pos1[0] = blockPos;
            }
        });
        return pos1[0];
    }

    @Nullable
    public static BlockPos takeManaNearbyWithParticles(BlockPos pos, World world, int range, int mana) {
        BlockPos result = ManaUtil.takeManaNearby(pos, world, range, mana);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, result, pos);
            world.func_217376_c((Entity)aoeProjectile);
        }
        return result;
    }

    @Nullable
    public static boolean hasManaNearby(BlockPos pos, World world, int range, int mana) {
        boolean[] hasMana = new boolean[]{false};
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, range, range), (BlockPos)pos.func_177982_a(-range, -range, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (!hasMana[0] && world.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(blockPos)).getCurrentMana() >= mana) {
                hasMana[0] = true;
            }
        });
        return hasMana[0];
    }

    @Nullable
    public static BlockPos canGiveMana(BlockPos pos, World world, int range) {
        boolean[] hasMana = new boolean[]{false};
        BlockPos[] loc = new BlockPos[]{null};
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, range, range), (BlockPos)pos.func_177982_a(-range, -range, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (!hasMana[0] && world.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(blockPos)).canAcceptMana()) {
                hasMana[0] = true;
                loc[0] = blockPos;
            }
        });
        return loc[0];
    }

    @Nullable
    public static BlockPos canGiveManaClosest(BlockPos pos, World world, int range) {
        Optional loc = BlockPos.func_239584_a_((BlockPos)pos, (int)range, (int)range, b -> world.func_175625_s(b) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(b)).canAcceptMana());
        return loc.orElse(null);
    }
}

