/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;

public class NBTUtil {
    public static CompoundNBT storeBlockPos(CompoundNBT tag, String prefix, BlockPos pos) {
        tag.func_74780_a(prefix + "_x", (double)pos.func_177958_n());
        tag.func_74780_a(prefix + "_y", (double)pos.func_177956_o());
        tag.func_74780_a(prefix + "_z", (double)pos.func_177952_p());
        return tag;
    }

    public static CompoundNBT removeBlockPos(CompoundNBT tag, String prefix) {
        tag.func_82580_o(prefix + "_x");
        tag.func_82580_o(prefix + "_y");
        tag.func_82580_o(prefix + "_z");
        return tag;
    }

    public static BlockPos getBlockPos(CompoundNBT tag, String prefix) {
        return new BlockPos(tag.func_74769_h(prefix + "_x"), tag.func_74769_h(prefix + "_y"), tag.func_74769_h(prefix + "_z"));
    }

    public static boolean hasBlockPos(CompoundNBT tag, String prefix) {
        return tag.func_74764_b(prefix + "_x");
    }

    public static List<ItemStack> readItems(CompoundNBT tag, String prefix) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (tag == null) {
            return stacks;
        }
        for (String s : tag.func_150296_c()) {
            if (!s.contains(prefix)) continue;
            stacks.add(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(s)));
        }
        return stacks;
    }

    public static void writeItems(CompoundNBT tag, String prefix, List<ItemStack> items) {
        for (ItemStack item : items) {
            CompoundNBT itemTag = new CompoundNBT();
            item.func_77955_b(itemTag);
            tag.func_218657_a(NBTUtil.getItemKey(item, prefix), (INBT)itemTag);
        }
    }

    public static String getItemKey(ItemStack stack, String prefix) {
        return prefix + stack.func_77973_b().getRegistryName().toString();
    }
}

