/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;

public class SpellUtil {
    public static boolean postEvent(SpellCastEvent e) {
        return MinecraftForge.EVENT_BUS.post((Event)e);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockRayTraceResult mop, int aoeBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, 1 + aoeBonus, 1 + aoeBonus, 1, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockRayTraceResult mop, int aoeBonus, int pierceBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, 1 + aoeBonus, 1 + aoeBonus, 1 + pierceBonus, -1);
    }

    public static List<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockRayTraceResult mop, int width, int height, int depth, int distance) {
        Vector3i hitVec = caster.func_174811_aO().func_176730_m();
        if (caster instanceof FakePlayer) {
            mop = new BlockRayTraceResult(mop.func_216347_e(), mop.func_216354_b(), mop.func_216350_a(), false);
        }
        return SpellUtil.calcAOEBlocks(hitVec, origin, mop, width, height, depth, distance);
    }

    public static List<BlockPos> calcAOEBlocks(Vector3d hitVec, BlockPos origin, BlockRayTraceResult mop, int width, int height, int depth, int distance) {
        return SpellUtil.calcAOEBlocks(Direction.func_210769_a((double)hitVec.field_72450_a, (double)hitVec.field_72448_b, (double)hitVec.field_72449_c).func_176734_d().func_176730_m(), origin, mop, width, height, depth, distance);
    }

    public static List<BlockPos> calcAOEBlocks(Vector3i facingVec, BlockPos origin, BlockRayTraceResult mop, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        BlockPos start = origin;
        switch (mop.func_216353_d() ? Direction.DOWN : mop.func_216354_b()) {
            case DOWN: 
            case UP: {
                x = facingVec.func_177958_n() * height + facingVec.func_177952_p() * width;
                y = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                z = facingVec.func_177958_n() * width + facingVec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.func_216347_e().field_72448_b - (double)mop.func_216350_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.func_216347_e().field_72448_b - (double)mop.func_216350_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ArrayList<BlockPos> builder = new ArrayList<BlockPos>();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance) continue;
                    BlockPos pos = new BlockPos(xp, yp, zp);
                    builder.add(pos);
                }
            }
        }
        builder.add(origin);
        return builder;
    }
}

