/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.DropDistribution;
import com.hollingsworth.arsnouveau.api.util.MappingUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.particle.engine.ParticleEngine;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketGetPersistentData;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class PlayerEvent {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    @SubscribeEvent
    public static void onTick(TickEvent.RenderTickEvent evt) {
        ParticleEngine.getInstance().tick();
    }

    @SubscribeEvent
    public static void onBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity entity = event.getPlayer();
        if (!event.getWorld().field_72995_K || event.getHand() != Hand.MAIN_HAND || event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof ScribesBlock) {
            return;
        }
        if (entity.func_184586_b(event.getHand()).func_77973_b() instanceof SpellBook) {
            event.setCanceled(true);
            ObfuscationReflectionHelper.setPrivateValue(FirstPersonRenderer.class, (Object)minecraft.func_175597_ag(), (Object)Float.valueOf(1.0f), (String)MappingUtil.getEquippedProgressMainhand());
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)stack);
        if (level > 0 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("spell")) {
            Spell spell = new Spell(SpellParchment.getSpellRecipe(stack));
            event.getToolTip().add(new StringTextComponent(spell.getDisplayString()));
        }
    }

    @SubscribeEvent
    public static void onItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity entity = event.getPlayer();
        if (!event.getWorld().field_72995_K || event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        if (entity.func_184586_b(event.getHand()).func_77973_b() instanceof SpellBook) {
            event.setCanceled(true);
            ObfuscationReflectionHelper.setPrivateValue(FirstPersonRenderer.class, (Object)minecraft.func_175597_ag(), (Object)Float.valueOf(1.0f), (String)MappingUtil.getEquippedProgressMainhand());
        }
    }

    @SubscribeEvent
    public static void playerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer().func_70644_a((Effect)ModPotions.SCRYING_EFFECT)) {
            CompoundNBT tag = event.getPlayer().getPersistentData().func_74775_l("PlayerPersisted");
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketGetPersistentData(tag));
        }
    }

    @SubscribeEvent
    public static void playerRender(RenderPlayerEvent event) {
    }

    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && event.player.func_70660_b((Effect)ModPotions.SCRYING_EFFECT) != null && ClientInfo.ticksInGame % 30 == 0) {
            ArrayList<BlockPos> scryingPos = new ArrayList<BlockPos>();
            CompoundNBT tag = ClientInfo.persistentData;
            if (!tag.func_74764_b("an_scrying")) {
                return;
            }
            PlayerEntity playerEntity = event.player;
            World world = playerEntity.field_70170_p;
            for (BlockPos p : BlockPos.func_239583_a_((BlockPos)playerEntity.func_233580_cy_(), (int)20, (int)120, (int)20)) {
                if (p.func_177956_o() >= world.func_217301_I() || world.func_180495_p(p).isAir((IBlockReader)world, p)) continue;
                if (scryingPos.size() >= 50) break;
                if (!world.func_180495_p(p).func_177230_c().getRegistryName().toString().equals(tag.func_74779_i("an_scrying"))) continue;
                scryingPos.add(new BlockPos((Vector3i)p));
            }
            ClientInfo.scryingPositions = scryingPos;
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity == null || playerEntity.func_70660_b((Effect)ModPotions.SCRYING_EFFECT) == null) {
            return;
        }
        Vector3d vector3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        double xView = vector3d.func_82615_a();
        double yView = vector3d.func_82617_b();
        double zView = vector3d.func_82616_c();
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (BlockPos p : ClientInfo.scryingPositions) {
            ParticleColor color = new ParticleColor(DropDistribution.rand.nextInt(255), DropDistribution.rand.nextInt(255), DropDistribution.rand.nextInt(255));
            BlockPos renderPos = new BlockPos((Vector3i)p);
            if (Math.abs(yView - (double)p.func_177956_o()) >= 30.0) {
                renderPos = new BlockPos((double)p.func_177958_n(), (double)p.func_177956_o() > yView ? yView + 20.0 : yView - 20.0, (double)p.func_177952_p());
                color = new ParticleColor(DropDistribution.rand.nextInt(30), DropDistribution.rand.nextInt(255), DropDistribution.rand.nextInt(50));
            }
            if (Math.abs(yView - (double)p.func_177956_o()) >= 60.0) {
                renderPos = new BlockPos((double)p.func_177958_n(), (double)p.func_177956_o() > yView ? yView + 20.0 : yView - 20.0, (double)p.func_177952_p());
                color = new ParticleColor(DropDistribution.rand.nextInt(50), DropDistribution.rand.nextInt(50), DropDistribution.rand.nextInt(255));
            }
            world.func_195594_a(GlowParticleData.createData(color, true), (double)renderPos.func_177958_n() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), (double)renderPos.func_177956_o() + 0.2 + ParticleUtil.inRange(-0.1, 0.1), (double)renderPos.func_177952_p() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), 0.0, (double)0.03f, 0.0);
        }
    }
}

