/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetBookMode;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiRadialMenu
extends Screen {
    private static final float PRECISION = 5.0f;
    private KeyBinding keybinding;
    private boolean closing;
    private boolean doneClosing;
    private double startAnimation;
    private CompoundNBT tag;
    private int selectedItem;

    public GuiRadialMenu(KeyBinding keybinding, CompoundNBT book_tag) {
        super((ITextComponent)new StringTextComponent(""));
        this.keybinding = keybinding;
        this.tag = book_tag;
        this.closing = false;
        this.doneClosing = false;
        Minecraft mc = Minecraft.func_71410_x();
        this.startAnimation = (double)mc.field_71441_e.func_82737_E() + (double)mc.func_184121_ak();
        this.selectedItem = -1;
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiRadialMenu && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
        }
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int adjusted;
        float e;
        float s;
        int i;
        float openAnimation;
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        float OPEN_ANIMATION_LENGTH = 2.5f;
        long worldTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        float animationTime = (float)((double)((float)worldTime + partialTicks) - this.startAnimation);
        float f = openAnimation = this.closing ? 1.0f - animationTime / 2.5f : animationTime / 2.5f;
        if (this.closing && openAnimation <= 0.0f) {
            this.doneClosing = true;
        }
        float animProgress = MathHelper.func_76131_a((float)openAnimation, (float)0.0f, (float)1.0f);
        float radiusIn = Math.max(0.1f, 45.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        float animTop = (1.0f - animProgress) * (float)this.field_230709_l_ / 2.0f;
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        int numberOfSlices = 10;
        double a = Math.toDegrees(Math.atan2(mouseY - y, mouseX - x));
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        float s0 = (-0.5f / (float)numberOfSlices + 0.25f) * 360.0f;
        if (a < (double)s0) {
            a += 360.0;
        }
        RenderSystem.pushMatrix();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translated((double)0.0, (double)animTop, (double)0.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numberOfSlices; ++i) {
                s = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                e = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)radiusIn) || !(d < (double)radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numberOfSlices; ++i) {
            s = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            e = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            if (this.selectedItem == i) {
                this.drawSlice(buffer, x, y, 10.0f, radiusIn, radiusOut, s, e, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = this.selectedItem;
                continue;
            }
            this.drawSlice(buffer, x, y, 10.0f, radiusIn, radiusOut, s, e, 0, 0, 0, 64);
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        if (hasMouseOver && mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + 6) % 10;
            adjusted = adjusted == 0 ? 10 : adjusted;
            String string = SpellBook.getSpellName(this.tag, adjusted);
            int n = this.field_230708_k_ / 2;
            this.field_230712_o_.getClass();
            GuiRadialMenu.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)string, (int)n, (int)((this.field_230709_l_ - 9) / 2), (int)0xFFFFFF);
        }
        RenderHelper.func_227780_a_();
        RenderSystem.popMatrix();
        for (i = 0; i < numberOfSlices; ++i) {
            ItemStack stack = new ItemStack((IItemProvider)Blocks.field_150346_d);
            float angle1 = ((float)i / (float)numberOfSlices - 0.25f) * 2.0f * (float)Math.PI;
            float posX = (float)(x - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(y - 8) + itemRadius * (float)Math.sin(angle1);
            String resourceIcon = "";
            String castType = "";
            for (AbstractSpellPart p : SpellBook.getRecipeFromTag((CompoundNBT)this.tag, (int)(i + 1)).recipe) {
                if (p instanceof AbstractCastMethod) {
                    castType = p.getIcon();
                }
                if (!(p instanceof AbstractEffect)) continue;
                resourceIcon = p.getIcon();
                break;
            }
            RenderSystem.disableRescaleNormal();
            RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            if (!resourceIcon.isEmpty()) {
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + resourceIcon), (int)posX, (int)posY, 0, 0, 16, 16, 16, 16, ms);
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + castType), (int)posX + 3, (int)posY - 10, 0, 0, 10, 10, 10, 10, ms);
            }
            this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, (int)posX + 5, (int)posY, String.valueOf(i + 1));
        }
        if (mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + 6) % 10;
            this.selectedItem = adjusted = adjusted == 0 ? 10 : adjusted;
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.selectedItem != -1) {
            SpellBook.setMode(this.tag, this.selectedItem);
            Networking.INSTANCE.sendToServer((Object)new PacketSetBookMode(this.tag));
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return true;
    }

    private void drawSlice(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, MathHelper.func_76123_f((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.func_225582_a_((double)pos1OutX, (double)pos1OutY, (double)z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)pos1InX, (double)pos1InY, (double)z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)pos2InX, (double)pos2InY, (double)z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)pos2OutX, (double)pos2OutY, (double)z).func_225586_a_(r, g, b, a).func_181675_d();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

