/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class EnchantingApparatusRecipeCategory
implements IRecipeCategory<EnchantingApparatusRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ars_nouveau", "apparatus");
    IGuiHelper helper;
    public IDrawable background;
    public IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public EnchantingApparatusRecipeCategory(final IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createBlankDrawable(60, 30);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockRegistry.ENCHANTING_APP_BLOCK));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return EnchantingApparatusRecipe.class;
    }

    public String getTitle() {
        return "Enchanting Apparatus";
    }

    public IDrawable getBackground() {
        return this.helper.createBlankDrawable(100, 60);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(EnchantingApparatusRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(matrixStack, 55, 22);
    }

    public void setIngredients(EnchantingApparatusRecipe o, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> itemStacks = new ArrayList<List<ItemStack>>();
        itemStacks.add(Arrays.asList(o.reagent.func_193365_a()));
        itemStacks.add(Collections.singletonList(o.result));
        for (Ingredient i : o.pedestalItems) {
            itemStacks.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, itemStacks);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)o.result);
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnchantingApparatusRecipe o, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 18, 22);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(++index, true, 80, 22);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        try {
            recipeLayout.getItemStacks().init(++index, true, 0, 4);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(2));
            recipeLayout.getItemStacks().init(++index, true, 18, 4);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(3));
            recipeLayout.getItemStacks().init(++index, true, 36, 4);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(4));
            recipeLayout.getItemStacks().init(++index, true, 0, 22);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(5));
            recipeLayout.getItemStacks().init(++index, true, 36, 22);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(6));
            recipeLayout.getItemStacks().init(++index, true, 0, 40);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(7));
            recipeLayout.getItemStacks().init(++index, true, 18, 40);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(8));
            recipeLayout.getItemStacks().init(++index, true, 36, 40);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(9));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

