/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ParticleUtil {
    public static Random r = new Random();

    public static double inRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static double getCenterOfBlock(double a) {
        return a + 0.5;
    }

    public static Vector3d pointInSphere() {
        double u = Math.random();
        double v = Math.random();
        double theta = u * 2.0 * Math.PI;
        double phi = Math.acos(2.0 * v - 1.0);
        double r = Math.cbrt(Math.random());
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double x = r * sinPhi * cosTheta;
        double y = r * sinPhi * sinTheta;
        double z = r * cosPhi;
        return new Vector3d(x, y, z);
    }

    public static void spawnFollowProjectile(World world, BlockPos from, BlockPos to) {
        if (world.func_72863_F().func_222865_a(new ChunkPos(from)) && world.func_72863_F().func_222865_a(new ChunkPos(to))) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, from, to);
            world.func_217376_c((Entity)aoeProjectile);
        }
    }

    public static void beam(BlockPos toThisBlock, BlockPos fromThisBlock, World world) {
        double x2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177958_n());
        double z2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177952_p());
        double y2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177956_o());
        double x1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177958_n());
        double z1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177952_p());
        double y1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177956_o());
        double d5 = 1.2;
        double d0 = x2 - x1;
        double d1 = y2 - y1;
        double d2 = z2 - z1;
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = r.nextDouble();
        while (d4 + 0.65 < d3) {
            d4 += 1.8 - d5 + r.nextDouble() * (1.5 - d5);
            if (world.field_72995_K) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, 0.0, 0.0, 0.0);
            }
            if (!(world instanceof ServerWorld)) continue;
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197607_R, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, r.nextInt(4), 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static ParticleColor defaultParticleColor() {
        return new ParticleColor(255, 25, 180);
    }

    public static ParticleColor.IntWrapper defaultParticleColorWrapper() {
        return new ParticleColor.IntWrapper(255, 25, 180);
    }

    public static void spawnPoof(ServerWorld world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 1.2;
            double d2 = (double)pos.func_177952_p() + 0.5;
            world.func_195598_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, 2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, (double)0.1f);
        }
    }

    public static void spawnTouch(ClientWorld world, BlockPos loc) {
        ParticleUtil.spawnTouch(world, loc, ParticleUtil.defaultParticleColor());
    }

    public static void spawnTouch(ClientWorld world, BlockPos loc, ParticleColor particleColor) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)loc.func_177958_n() + 0.5;
            double d1 = (double)loc.func_177956_o() + 1.0;
            double d2 = (double)loc.func_177952_p() + 0.5;
            world.func_195594_a(GlowParticleData.createData(particleColor), d0, d1, d2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 5.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 5.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 5.0);
        }
    }

    public static void spawnRitualAreaEffect(TileEntity entity, Random rand, ParticleColor color, int range) {
        BlockPos pos = entity.func_174877_v();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, 0, range), (BlockPos)pos.func_177982_a(-range, 0, -range)).forEach(blockPos -> {
            if (rand.nextInt(10) == 0) {
                for (int i = 0; i < rand.nextInt(10); ++i) {
                    double x = (double)blockPos.func_177958_n() + ParticleUtil.inRange(-0.5, 0.5);
                    double y = (double)blockPos.func_177956_o() + ParticleUtil.inRange(-0.5, 0.5);
                    double z = (double)blockPos.func_177952_p() + ParticleUtil.inRange(-0.5, 0.5);
                    entity.func_145831_w().func_195594_a(ParticleLineData.createData(color), x, y, z, x, y + ParticleUtil.inRange(0.5, 5.0), z);
                }
            }
        });
    }

    public static void spawnRitualSkyEffect(TileEntity tileEntity, Random rand, ParticleColor.IntWrapper color) {
        int min = -5;
        int max = 5;
        BlockPos nearPos = new BlockPos(tileEntity.func_174877_v().func_177958_n() + rand.nextInt(max - min) + min, tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p() + rand.nextInt(max - min) + min);
        BlockPos toPos = nearPos.func_177981_b(rand.nextInt(3) + 10);
        EntityFollowProjectile proj1 = new EntityFollowProjectile(tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177984_a(), toPos, color);
        proj1.func_184212_Q().func_187227_b(EntityFollowProjectile.SPAWN_TOUCH, (Object)true);
        proj1.func_184212_Q().func_187227_b(EntityFollowProjectile.DESPAWN, (Object)15);
        tileEntity.func_145831_w().func_217376_c((Entity)proj1);
    }

    public static void spawnRitualSkyEffect(AbstractRitual ritual, TileEntity tileEntity, Random rand, ParticleColor.IntWrapper color) {
        int scalar = 20;
        if (ritual.getContext().progress >= 5) {
            scalar = 10;
        }
        if (ritual.getContext().progress >= 10) {
            scalar = 5;
        }
        if (ritual.getContext().progress >= 13) {
            scalar = 3;
        }
        if (!(ritual.getWorld().field_72995_K || ritual.getProgress() > 15 || ritual.getWorld().func_82737_E() % 20L != 0L && rand.nextInt(scalar) != 0)) {
            ParticleUtil.spawnRitualSkyEffect(tileEntity, rand, color);
        }
    }

    public static void spawnFallingSkyEffect(TileEntity tileEntity, Random rand, ParticleColor.IntWrapper color) {
        int min = -5;
        int max = 5;
        BlockPos nearPos = new BlockPos(tileEntity.func_174877_v().func_177958_n() + rand.nextInt(max - min) + min, tileEntity.func_174877_v().func_177956_o() + 8, tileEntity.func_174877_v().func_177952_p() + rand.nextInt(max - min) + min);
        BlockPos toPos = nearPos.func_177979_c(8);
        EntityFollowProjectile proj1 = new EntityFollowProjectile(tileEntity.func_145831_w(), nearPos, toPos, color);
        proj1.func_184212_Q().func_187227_b(EntityFollowProjectile.SPAWN_TOUCH, (Object)true);
        proj1.func_184212_Q().func_187227_b(EntityFollowProjectile.DESPAWN, (Object)20);
        tileEntity.func_145831_w().func_217376_c((Entity)proj1);
    }

    public static void spawnFallingSkyEffect(AbstractRitual ritual, TileEntity tileEntity, Random rand, ParticleColor.IntWrapper color) {
        int scalar = 20;
        if (ritual.getContext().progress >= 5) {
            scalar = 10;
        }
        if (ritual.getContext().progress >= 10) {
            scalar = 5;
        }
        if (ritual.getContext().progress >= 13) {
            scalar = 3;
        }
        if (!(ritual.getWorld().field_72995_K || ritual.getProgress() > 15 || ritual.getWorld().func_82737_E() % 20L != 0L && rand.nextInt(scalar) != 0)) {
            ParticleUtil.spawnFallingSkyEffect(tileEntity, rand, color);
        }
    }
}

