/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle.engine;

import com.hollingsworth.arsnouveau.client.particle.engine.TimedEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ParticleEngine {
    List<TimedEffect> effects = new ArrayList<TimedEffect>();
    private static ParticleEngine particleEngine;

    public void tick() {
        if (this.effects == null || this.effects.size() == 0) {
            return;
        }
        ListIterator<TimedEffect> effectListIterator = this.effects.listIterator();
        while (effectListIterator.hasNext()) {
            TimedEffect effect = effectListIterator.next();
            if (effect.isDone) {
                effectListIterator.remove();
                continue;
            }
            effect.tick();
        }
    }

    public void addEffect(TimedEffect effect) {
        this.effects.add(effect);
    }

    public static ParticleEngine getInstance() {
        if (particleEngine == null) {
            particleEngine = new ParticleEngine();
        }
        return particleEngine;
    }

    private ParticleEngine() {
    }
}

