/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle.engine;

import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.particle.engine.TimedEffect;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;

public class TimedBeam
extends TimedEffect {
    int delay;

    public TimedBeam(BlockPos toPos, BlockPos fromPos, int delay, ClientWorld world) {
        this.particles = TimedBeam.beam(toPos, fromPos);
        this.delay = delay;
        this.world = world;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world == null || this.particles.isEmpty()) {
            this.isDone = true;
            return;
        }
        if (this.delay == 0 || this.ticks % this.delay == 0) {
            ((TimedEffect.ParticleElem)this.particles.poll()).addToWorld(this.world);
        }
    }

    public static LinkedList<TimedEffect.ParticleElem> beam(BlockPos toThisBlock, BlockPos fromThisBlock) {
        Random rand = new Random();
        double x2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177958_n());
        double z2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177952_p());
        double y2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177956_o());
        double x1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177958_n());
        double z1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177952_p());
        double y1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177956_o());
        double d5 = 1.2;
        double d0 = x2 - x1;
        double y = toThisBlock.func_177956_o() - fromThisBlock.func_177956_o();
        double d1 = y2 - y1;
        double d2 = z2 - z1;
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = 0.1;
        LinkedList<TimedEffect.ParticleElem> elemArrayList = new LinkedList<TimedEffect.ParticleElem>();
        while (d4 < d3) {
            d4 += 1.8 - d5 + 0.05 * (1.5 - d5);
            for (int i = 0; i < 3; ++i) {
                elemArrayList.add(new TimedEffect.ParticleElem(GlowParticleData.createData(new ParticleColor(255, 25, 155)), x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, 0.0, 0.0, 0.0));
            }
        }
        return elemArrayList;
    }
}

