/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle.engine;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.particle.engine.TimedEffect;
import java.util.LinkedList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;

public class TimedHelix
extends TimedEffect {
    BlockPos pos;
    int delay;

    public TimedHelix(BlockPos pos, int delay, IParticleData data, ClientWorld world) {
        this.particles = this.buildList(pos, data);
        this.delay = delay;
        this.world = world;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world == null || this.particles.isEmpty()) {
            this.isDone = true;
            return;
        }
        if (this.delay == 0) {
            ((TimedEffect.ParticleElem)this.particles.poll()).addToWorld(this.world);
        } else if (this.ticks % this.delay == 0) {
            ((TimedEffect.ParticleElem)this.particles.poll()).addToWorld(this.world);
        }
    }

    public LinkedList<TimedEffect.ParticleElem> buildList(BlockPos pos, IParticleData particle) {
        double radius = 0.75;
        LinkedList<TimedEffect.ParticleElem> elemArrayList = new LinkedList<TimedEffect.ParticleElem>();
        for (double y = 0.0; y <= 4.0; y += 0.25) {
            double x = radius * Math.cos(y);
            double z = radius * Math.sin(y);
            elemArrayList.add(new TimedEffect.ParticleElem(particle, ParticleUtil.getCenterOfBlock(pos.func_177958_n()) + x, (double)pos.func_177956_o() + 1.5 + y, ParticleUtil.getCenterOfBlock(pos.func_177952_p()) + z, 0.0, 0.0, 0.0));
            elemArrayList.add(new TimedEffect.ParticleElem(particle, ParticleUtil.getCenterOfBlock(pos.func_177958_n()) + -x, (double)pos.func_177956_o() + 1.5 + y, ParticleUtil.getCenterOfBlock(pos.func_177952_p()) + -z, 0.0, 0.0, 0.0));
        }
        return elemArrayList;
    }
}

