/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class CarbuncleModel
extends AnimatedGeoModel<EntityCarbuncle> {
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
    private static final ResourceLocation TAMED_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");

    public void setLivingAnimations(EntityCarbuncle entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        IBone backLeft = this.getAnimationProcessor().getBone("back_leg_right");
        IBone backRight = this.getAnimationProcessor().getBone("back_leg_right");
        IBone frontLeft = this.getAnimationProcessor().getBone("front_leg_left");
        IBone frontRight = this.getAnimationProcessor().getBone("front_leg_right");
        backRight.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f)) * 1.4f * entity.field_70721_aZ);
        backLeft.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f + (float)Math.PI)) * 1.4f * entity.field_70721_aZ);
        frontLeft.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f)) * 1.4f * entity.field_70721_aZ);
        frontRight.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f + (float)Math.PI)) * 1.4f * entity.field_70721_aZ);
    }

    public ResourceLocation getModelLocation(EntityCarbuncle carbuncle) {
        return new ResourceLocation("ars_nouveau", "geo/carbuncle.geo.json");
    }

    public ResourceLocation getTextureLocation(EntityCarbuncle carbuncle) {
        return carbuncle.isTamed() ? TAMED_TEXTURE : WILD_TEXTURE;
    }

    public ResourceLocation getAnimationFileLocation(EntityCarbuncle carbuncle) {
        return new ResourceLocation("ars_nouveau", "animations/carbuncle_animations.json");
    }
}

