/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.renderer.entity.CarbuncleHeldItemLayer;
import com.hollingsworth.arsnouveau.client.renderer.entity.CarbuncleModel;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class CarbuncleRenderer
extends GeoEntityRenderer<EntityCarbuncle> {
    private static final ResourceLocation ORANGE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_purple.png");
    private static final ResourceLocation GREEN = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_green.png");
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");

    public CarbuncleRenderer(EntityRendererManager manager) {
        super(manager, (AnimatedGeoModel)new CarbuncleModel());
        this.addLayer(new CarbuncleHeldItemLayer((IGeoRenderer<EntityCarbuncle>)this));
    }

    protected void applyRotations(EntityCarbuncle entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public void render(EntityCarbuncle entity, float entityYaw, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int p_225623_6_) {
        super.render((LivingEntity)entity, entityYaw, p_225623_3_, matrixStack, iRenderTypeBuffer, p_225623_6_);
    }

    public ResourceLocation getColor(EntityCarbuncle e) {
        String color = ((String)e.func_184212_Q().func_187225_a(EntityCarbuncle.COLOR)).toLowerCase();
        if (color.isEmpty()) {
            return ORANGE;
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    public ResourceLocation getTextureLocation(EntityCarbuncle entity) {
        return entity.isTamed() ? this.getColor(entity) : WILD_TEXTURE;
    }

    public RenderType getRenderType(EntityCarbuncle animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228640_c_((ResourceLocation)textureLocation);
    }
}

