/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBowModel;
import com.hollingsworth.arsnouveau.common.items.Wand;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class SpellBowRenderer
extends FixedGeoItemRenderer<Wand> {
    public SpellBowRenderer() {
        super(new SpellBowModel());
    }

    @Override
    public void func_239207_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack stack, IRenderTypeBuffer bufferIn, int combinedLightIn, int p_239207_6_) {
        if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Vector3d playerPos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            Vector3d look = player.func_70040_Z();
            Vector3d right = new Vector3d(-look.field_72449_c, 0.0, look.field_72450_a).func_72432_b();
            Vector3d forward = look;
            Vector3d down = right.func_72431_c(forward);
            right = right.func_186678_a(0.2 - (double)player.field_70733_aJ);
            forward = forward.func_186678_a((double)0.45f);
            down = down.func_186678_a(-0.1 - (double)player.field_70733_aJ);
            Vector3d laserPos = playerPos.func_178787_e(right);
            laserPos = laserPos.func_178787_e(forward);
            laserPos = laserPos.func_178787_e(down);
            SpellCaster tool = SpellCaster.deserialize(itemStack);
            int timeHeld = 72000 - Minecraft.func_71410_x().field_71439_g.func_184605_cv();
            if (timeHeld > 0 && timeHeld != 72000) {
                float scaleAge = (float)ParticleUtil.inRange(0.05, 0.1);
                if (player.field_70170_p.field_73012_v.nextInt(6) == 0) {
                    for (int i = 0; i < 1; ++i) {
                        Vector3d particlePos = new Vector3d(laserPos.field_72450_a, laserPos.field_72448_b, laserPos.field_72449_c);
                        particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere().func_186678_a((double)0.3f));
                        player.field_70170_p.func_195594_a(ParticleLineData.createData(tool.getColor().toParticleColor(), scaleAge, 5 + player.field_70170_p.field_73012_v.nextInt(20)), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), laserPos.func_82615_a(), laserPos.func_82617_b(), laserPos.func_82616_c());
                    }
                }
            }
        }
        super.func_239207_a_(itemStack, transformType, stack, bufferIn, combinedLightIn, p_239207_6_);
    }

    public void render(GeoModel model, Object animatable, float partialTicks, RenderType type, MatrixStack matrixStackIn, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        int timeHeld;
        IBone top = (IBone)model.getBone("bow_top").get();
        IBone gem = (IBone)model.getBone("gem").get();
        IBone bottom = (IBone)model.getBone("bow_top2").get();
        float outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 10.0f % 360.0f;
        top.setRotationZ((float)Math.toRadians(-10.0));
        top.setRotationY(0.0f);
        top.setRotationX(0.0f);
        bottom.setRotationZ((float)Math.toRadians(10.0));
        bottom.setRotationY(0.0f);
        bottom.setRotationX((float)Math.toRadians(-180.0));
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().equals(this.currentItemStack) && (timeHeld = (int)((float)(72000 - Minecraft.func_71410_x().field_71439_g.func_184605_cv()) + partialTicks)) != 0 && timeHeld != 72000) {
            top.setRotationZ((float)(Math.toRadians(-10.0) - Math.toRadians(timeHeld) * 2.0));
            bottom.setRotationZ((float)(Math.toRadians(-10.0) + Math.toRadians(timeHeld) * 2.0));
            outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 5.0f % 360.0f;
            if (timeHeld >= 19) {
                top.setRotationZ((float)(Math.toRadians(-10.0) - Math.toRadians(19.0) * 2.0));
                bottom.setRotationZ((float)(Math.toRadians(-10.0) + Math.toRadians(19.0) * 2.0));
                outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 3.0f % 360.0f;
            }
        }
        gem.setRotationX(outerAngle);
        gem.setRotationY(outerAngle);
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }
}

