/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScribesBlock
extends ModBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public ScribesBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 3.0f).func_226896_b_(), "scribes_table");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (handIn != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        if (world.func_175625_s(pos) instanceof ScribesTile && !player.func_225608_bj_()) {
            ScribesTile tile = (ScribesTile)world.func_175625_s(pos);
            if (tile.stack != null && player.func_184586_b(handIn).func_190926_b()) {
                ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), tile.stack);
                world.func_217376_c((Entity)item);
                tile.stack = null;
            } else if (!player.field_71071_by.func_70448_g().func_190926_b()) {
                if (tile.stack != null) {
                    ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), tile.stack);
                    world.func_217376_c((Entity)item);
                }
                tile.stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            world.func_184138_a(pos, state, state, 2);
        }
        if (world.func_175625_s(pos) instanceof ScribesTile && player.func_225608_bj_()) {
            ItemStack stack = ((ScribesTile)world.func_175625_s((BlockPos)pos)).stack;
            if (stack == null || stack.func_190926_b()) {
                return ActionResultType.SUCCESS;
            }
            if (stack.func_77973_b() instanceof IScribeable) {
                ((IScribeable)stack.func_77973_b()).onScribe(world, pos, player, handIn, stack);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn.func_175625_s(pos) instanceof ScribesTile && ((ScribesTile)worldIn.func_175625_s((BlockPos)pos)).stack != null) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ScribesTile)worldIn.func_175625_s((BlockPos)pos)).stack));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)ScribesBlock.getFacingFromEntity(pos, entity)), 2);
        }
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        Direction direction = Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = Direction.NORTH;
        }
        return direction;
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!(event.getWorld().func_175625_s(event.getPos()) instanceof ScribesTile)) {
            return;
        }
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof ScribesBlock) {
            BlockRegistry.SCRIBES_BLOCK.func_225533_a_(world.func_180495_p(pos), world, pos, event.getPlayer(), event.getHand(), null);
            event.setCanceled(true);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ScribesTile();
    }
}

