/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SpellTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class SpellTurret
extends ModBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public SpellTurret() {
        super(SpellTurret.defaultProperties().func_226896_b_(), "spell_turret");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.shootSpell(worldIn, pos);
    }

    public void shootSpell(ServerWorld world, BlockPos pos) {
        SpellTurretTile tile = (SpellTurretTile)world.func_175625_s(pos);
        if (tile == null || tile.recipe == null || tile.recipe.isEmpty()) {
            return;
        }
        int manaCost = new Spell(tile.recipe).getCastingCost() / 2;
        if (ManaUtil.takeManaNearbyWithParticles(pos, (World)world, 10, manaCost) == null) {
            return;
        }
        IPosition iposition = SpellTurret.getDispensePosition((IBlockSource)new ProxyBlockSource(world, pos));
        Direction direction = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        ANFakePlayer fakePlayer = new ANFakePlayer(world);
        fakePlayer.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        EntitySpellResolver resolver = new EntitySpellResolver(tile.recipe, new SpellContext(tile.recipe, (LivingEntity)fakePlayer).withCastingTile(world.func_175625_s(pos)));
        if (resolver.castType instanceof MethodProjectile) {
            this.shootProjectile(world, pos, tile, resolver);
            return;
        }
        if (resolver.castType instanceof MethodTouch) {
            BlockPos touchPos = new BlockPos(iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                touchPos = touchPos.func_177972_a(direction);
            }
            if (direction == Direction.DOWN) {
                touchPos = touchPos.func_177977_b();
            }
            resolver.onCastOnBlock(new BlockRayTraceResult(new Vector3d((double)touchPos.func_177958_n(), (double)touchPos.func_177956_o(), (double)touchPos.func_177952_p()), direction.func_176734_d(), new BlockPos(touchPos.func_177958_n(), touchPos.func_177956_o(), touchPos.func_177952_p()), false), (LivingEntity)fakePlayer);
        }
    }

    public void shootProjectile(ServerWorld world, BlockPos pos, SpellTurretTile tile, SpellResolver resolver) {
        IPosition iposition = SpellTurret.getDispensePosition((IBlockSource)new ProxyBlockSource(world, pos));
        Direction direction = (Direction)world.func_180495_p(pos).func_177229_b((Property)DispenserBlock.field_176441_a);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)world);
        fakePlayer.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        EntityProjectileSpell spell = new EntityProjectileSpell((World)world, (LivingEntity)fakePlayer, resolver, AbstractSpellPart.getBuffCount(new Spell(tile.recipe).getAugments(0, null), AugmentPierce.class));
        spell.func_212361_a((Entity)fakePlayer);
        spell.func_70107_b(iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
        spell.func_70186_c(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e(), 0.5f, 0.0f);
        world.func_217376_c((Entity)spell);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = (Boolean)state.func_177229_b((Property)TRIGGERED);
        if (flag && !flag1) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
        } else if (!flag && flag1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return false;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public static IPosition getDispensePosition(IBlockSource coords) {
        Direction direction = (Direction)coords.func_189992_e().func_177229_b((Property)FACING);
        double d0 = coords.func_82615_a() + 0.5 * (double)direction.func_82601_c();
        double d1 = coords.func_82617_b() + 0.5 * (double)direction.func_96559_d();
        double d2 = coords.func_82616_c() + 0.5 * (double)direction.func_82599_e();
        return new Position(d0, d1, d2);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(handIn);
            if (!(stack.func_77973_b() instanceof SpellParchment) || worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            List<AbstractSpellPart> recipe = SpellParchment.getSpellRecipe(stack);
            if (recipe == null || recipe.isEmpty()) {
                return ActionResultType.SUCCESS;
            }
            if (!(recipe.get(0) instanceof MethodTouch) && !(recipe.get(0) instanceof MethodProjectile)) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.alert.turret_type"));
                return ActionResultType.SUCCESS;
            }
            ((SpellTurretTile)worldIn.func_175625_s((BlockPos)pos)).recipe = recipe;
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.alert.spell_set"));
            worldIn.func_184138_a(pos, state, state, 2);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TRIGGERED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpellTurretTile();
    }
}

