/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ManaBloomCrop;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ManaCondenserTile
extends AbstractManaTile {
    public boolean isDisabled = false;

    public ManaCondenserTile() {
        super(BlockRegistry.MANA_CONDENSER_TILE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public void func_73660_a() {
        ManaJarTile jar;
        if (this.field_145850_b.field_72995_K || this.isDisabled) {
            return;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()) instanceof ManaJarTile && (jar = (ManaJarTile)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())).canAcceptMana() && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.transferMana(this, jar);
        }
    }

    @Override
    public int getCurrentMana() {
        return super.getCurrentMana();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.isDisabled = tag.func_74767_n("disabled");
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("disabled", this.isDisabled);
        return super.func_189515_b(tag);
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Post event) {
        if (this.isDisabled || this.field_145850_b == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.field_174879_c, event.getPos()) <= 15.0) {
            int mana = 50;
            if (this.field_145850_b.func_180495_p(event.getPos()).func_177230_c() instanceof ManaBloomCrop) {
                mana += 25;
            }
            this.addMana(mana);
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, event.getPos(), this.field_174879_c);
        }
    }

    @SubscribeEvent
    public void babySpawnEvent(BabyEntitySpawnEvent event) {
        if (this.isDisabled || event.getChild() == null || this.field_145850_b == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.field_174879_c, event.getParentA().func_233580_cy_()) <= 15.0) {
            this.addMana(1000);
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, event.getParentA().func_233580_cy_(), this.field_174879_c);
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent e) {
        if (e.getEntityLiving().field_70170_p.field_72995_K || this.isDisabled || e.getEntity() instanceof IDispellable || this.field_145850_b == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.field_174879_c, e.getEntity().func_233580_cy_()) <= 15.0) {
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, e.getEntity().func_233580_cy_(), this.field_174879_c);
            this.addMana(200);
        }
    }

    @Override
    public int getTransferRate() {
        return 500;
    }
}

