/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.block.ManaJar;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PotionJarTile
extends TileEntity
implements ITickableTileEntity,
ITooltipProvider,
IWandable {
    private int amount;
    private Potion potion = Potions.field_185229_a;
    public boolean isLocked;
    private List<EffectInstance> customEffects = new ArrayList<EffectInstance>();

    public PotionJarTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public PotionJarTile() {
        super(BlockRegistry.POTION_JAR_TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        int fillState = 0;
        if (this.getCurrentFill() > 0 && this.getCurrentFill() < 1000) {
            fillState = 1;
        } else if (this.getCurrentFill() != 0) {
            fillState = this.getCurrentFill() / 1000 + 1;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.getAmount() <= 0 && this.potion != Potions.field_185229_a && !this.isLocked) {
            this.potion = Potions.field_185229_a;
            this.customEffects = new ArrayList<EffectInstance>();
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(ManaJar.fill, (Comparable)Integer.valueOf(fillState)), 3);
        }
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(ManaJar.fill, (Comparable)Integer.valueOf(fillState)), 3);
    }

    public boolean canAcceptNewPotion() {
        return this.amount <= 0 && !this.isLocked || this.potion == Potions.field_185229_a;
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        if (!this.isLocked) {
            this.isLocked = true;
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.locked"), Util.field_240973_b_);
        } else {
            this.isLocked = false;
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.unlocked"), Util.field_240973_b_);
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void setPotion(Potion potion, List<EffectInstance> effectInstances) {
        this.potion = potion == null ? Potions.field_185229_a : potion;
        this.customEffects = new ArrayList<EffectInstance>();
        for (EffectInstance e : effectInstances) {
            if (potion.func_185170_a().contains(e)) continue;
            this.customEffects.add(e);
        }
    }

    public void setPotion(ItemStack stack) {
        this.setPotion(PotionUtils.func_185191_c((ItemStack)stack), PotionUtils.func_185189_a((ItemStack)stack));
    }

    private void setPotion(Potion potion) {
        this.potion = potion == null ? Potions.field_185229_a : potion;
    }

    @Nonnull
    public Potion getPotion() {
        return this.potion == null ? Potions.field_185229_a : this.potion;
    }

    public int getColor() {
        return this.potion == null ? 0xF800F8 : PotionUtils.func_185181_a(this.getFullEffects());
    }

    public int getCurrentFill() {
        return this.getAmount();
    }

    public void setFill(int fill) {
        this.setAmount(fill);
    }

    public void addAmount(Potion potion, int fill) {
        this.setPotion(potion);
        this.addAmount(fill);
    }

    public void addAmount(int fill) {
        this.setAmount(Math.min(this.getMaxFill(), this.getAmount() + fill));
        if (this.getAmount() <= 0) {
            this.potion = Potions.field_185229_a;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.potion != null && this.potion != Potions.field_185229_a) {
            ItemStack potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)this.potion);
            list.add(potionStack.func_200301_q().getString());
            PotionUtils.func_185184_a((ItemStack)potionStack, this.customEffects);
            ArrayList tooltip = new ArrayList();
            PotionUtils.func_185182_a((ItemStack)potionStack, tooltip, (float)1.0f);
            for (ITextComponent i : tooltip) {
                list.add(i.getString());
            }
        }
        list.add(new TranslationTextComponent("ars_nouveau.mana_jar.fullness", new Object[]{this.getCurrentFill() * 100 / this.getMaxFill()}).getString());
        if (this.isLocked) {
            list.add(new TranslationTextComponent("ars_nouveau.locked").getString());
        }
        return list;
    }

    public void appendEffect(List<EffectInstance> effects) {
        this.customEffects.addAll(effects);
    }

    public void setCustomEffects(List<EffectInstance> effects) {
        this.customEffects.clear();
        this.customEffects.addAll(effects);
    }

    public List<EffectInstance> getFullEffects() {
        List<EffectInstance> thisEffects = this.getCustomEffects();
        thisEffects.addAll(this.potion.func_185170_a());
        return thisEffects;
    }

    public List<EffectInstance> getCustomEffects() {
        ArrayList<EffectInstance> thisEffects = new ArrayList<EffectInstance>(this.customEffects);
        return thisEffects;
    }

    public boolean isMixEqual(List<EffectInstance> effects) {
        ArrayList<EffectInstance> thisEffects = new ArrayList<EffectInstance>(this.customEffects);
        thisEffects.addAll(this.potion.func_185170_a());
        effects = new ArrayList<EffectInstance>(effects);
        if (thisEffects.size() != effects.size()) {
            return false;
        }
        effects.sort(Comparator.comparing(EffectInstance::toString));
        thisEffects.sort(Comparator.comparing(EffectInstance::toString));
        return thisEffects.equals(effects);
    }

    public boolean isMixEqual(Potion potion) {
        return this.isMixEqual(potion.func_185170_a());
    }

    public boolean isMixEqual(ItemStack stack) {
        return this.isMixEqual(PotionUtils.func_185189_a((ItemStack)stack));
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.amount = tag.func_74762_e("amount");
        this.potion = PotionUtils.func_185187_c((CompoundNBT)tag);
        this.customEffects = new ArrayList<EffectInstance>();
        this.customEffects.addAll(PotionUtils.func_185192_b((CompoundNBT)tag));
        this.isLocked = tag.func_74767_n("locked");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        ResourceLocation resourcelocation = Registry.field_212621_j.func_177774_c((Object)this.potion);
        tag.func_74768_a("amount", this.getAmount());
        tag.func_74778_a("Potion", resourcelocation.toString());
        tag.func_74757_a("locked", this.isLocked);
        if (!this.customEffects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.customEffects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            tag.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public int getMaxFill() {
        return 10000;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }
}

