/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;

public class RuneTile
extends AnimatedTile
implements IPickupResponder {
    public List<AbstractSpellPart> recipe;
    public boolean isTemporary = false;
    public boolean isCharged = true;
    public int ticksUntilCharge = 0;
    public UUID uuid;

    public RuneTile() {
        super(BlockRegistry.RUNE_TILE);
    }

    public void setRecipe(List<AbstractSpellPart> recipe) {
        this.recipe = recipe;
    }

    public void castSpell(Entity entity) {
        if (!(this.isCharged && this.recipe != null && !this.recipe.isEmpty() && entity instanceof LivingEntity && this.field_145850_b instanceof ServerWorld && this.recipe.get(0) instanceof MethodTouch)) {
            return;
        }
        try {
            FakePlayer playerEntity = this.uuid != null ? this.field_145850_b.func_217371_b(this.uuid) : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b));
            playerEntity = playerEntity == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b)) : playerEntity;
            EntitySpellResolver resolver = new EntitySpellResolver(this.recipe, new SpellContext(this.recipe, (LivingEntity)playerEntity).withCastingTile(this).withType(SpellContext.CasterType.RUNE));
            resolver.onCastOnEntity(ItemStack.field_190927_a, (LivingEntity)playerEntity, (LivingEntity)entity, Hand.MAIN_HAND);
            if (this.isTemporary) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
                return;
            }
            this.isCharged = false;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_235896_a_((Property)RuneBlock.POWERED));
            this.ticksUntilCharge = 40;
        }
        catch (Exception e) {
            PortUtil.sendMessage(entity, (ITextComponent)new TranslationTextComponent("ars_nouveau.rune.error"));
            e.printStackTrace();
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
    }

    public void setParsedSpell(List<AbstractSpellPart> spell) {
        if (spell.size() <= 1) {
            this.recipe = null;
            return;
        }
        spell.set(0, MethodTouch.INSTANCE);
        this.recipe = spell;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.recipe != null) {
            tag.func_74778_a("spell", SpellRecipeUtil.serializeForNBT(this.recipe));
        }
        tag.func_74757_a("charged", this.isCharged);
        tag.func_74757_a("temp", this.isTemporary);
        tag.func_74768_a("cooldown", this.ticksUntilCharge);
        if (this.uuid != null) {
            tag.func_186854_a("uuid", this.uuid);
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.recipe = SpellRecipeUtil.getSpellsFromTagString(tag.func_74779_i("spell"));
        this.isCharged = tag.func_74767_n("charged");
        this.isTemporary = tag.func_74767_n("temp");
        this.ticksUntilCharge = tag.func_74762_e("cooldown");
        if (tag.func_74764_b("uuid")) {
            this.uuid = tag.func_186857_a("uuid");
        }
        super.func_230337_a_(state, tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.ticksUntilCharge > 0) {
            --this.ticksUntilCharge;
            return;
        }
        if (this.isCharged) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.isTemporary) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockPos fromPos = ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 10, 100);
            if (fromPos != null) {
                this.isCharged = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_235896_a_((Property)RuneBlock.POWERED));
            } else {
                this.ticksUntilCharge = 60;
            }
        }
    }

    @Override
    public List<IItemHandler> getInventory() {
        return BlockUtil.getAdjacentInventories(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public ItemStack onPickup(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, stack);
    }
}

